/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mods.battlegear2.Battlegear;
import mods.battlegear2.api.EnchantmentHelper;
import mods.battlegear2.api.core.IBattlePlayer;
import mods.battlegear2.api.core.InventoryPlayerBattle;
import mods.battlegear2.api.weapons.Attributes;
import mods.battlegear2.api.weapons.IBackStabbable;
import mods.battlegear2.client.BattlegearClientTickHandeler;
import mods.battlegear2.client.ClientProxy;
import mods.battlegear2.client.gui.BattlegearInGameGUI;
import mods.battlegear2.client.gui.controls.GuiBGInventoryButton;
import mods.battlegear2.client.gui.controls.GuiPlaceableButton;
import mods.battlegear2.client.gui.controls.GuiSigilButton;
import mods.battlegear2.client.model.QuiverModel;
import mods.battlegear2.enchantments.BaseEnchantment;
import mods.battlegear2.packet.PickBlockPacket;
import mods.battlegear2.utils.BattlegearConfig;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.RenderSkeleton;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.ai.attributes.BaseAttribute;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class BattlegearClientEvents
implements IResourceManagerReloadListener {
    private final BattlegearInGameGUI inGameGUI = new BattlegearInGameGUI();
    public final QuiverModel quiverModel = new QuiverModel();
    public final ResourceLocation quiverDetails = new ResourceLocation("battlegear2", "textures/armours/quiver/QuiverDetails.png");
    public final ResourceLocation quiverBase = new ResourceLocation("battlegear2", "textures/armours/quiver/QuiverBase.png");
    private static final int MAIN_INV = InventoryPlayer.func_70451_h();
    public static final GuiPlaceableButton[] tabsList = new GuiPlaceableButton[]{new GuiBGInventoryButton(0), new GuiSigilButton(1)};
    public static final BattlegearClientEvents INSTANCE = new BattlegearClientEvents();
    private String[] attributeNames;
    private static final int SKELETON_ARROW = 5;
    private static final Pattern FLOAT = Pattern.compile("\\d.\\d+");

    private BattlegearClientEvents() {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
    }

    @SubscribeEvent(receiveCanceled=true)
    public void postRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.HOTBAR && (BattlegearConfig.forceHUD || !event.isCanceled())) {
            this.inGameGUI.renderGameOverlay(event.partialTicks);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void renderPlayerLeftItemUsage(RenderLivingEvent.Pre event) {
        ItemStack offhand;
        EntityPlayer entityPlayer;
        if (event.entity instanceof EntityPlayer && !(entityPlayer = (EntityPlayer)event.entity).func_175149_v() && event.renderer instanceof RenderPlayer && entityPlayer.field_71071_by instanceof InventoryPlayerBattle && (offhand = ((InventoryPlayerBattle)entityPlayer.field_71071_by).getCurrentOffhandWeapon()) != null) {
            ModelPlayer renderer = ((RenderPlayer)event.renderer).func_177087_b();
            renderer.field_78119_l = 1;
            if (entityPlayer.func_71052_bv() > 0 && entityPlayer.func_71011_bu() == offhand) {
                EnumAction enumaction = offhand.func_77975_n();
                if (enumaction == EnumAction.BLOCK) {
                    renderer.field_78119_l = 3;
                } else if (enumaction == EnumAction.BOW) {
                    renderer.field_78118_o = true;
                }
                ItemStack mainhand = entityPlayer.field_71071_by.func_70448_g();
                renderer.field_78120_m = mainhand != null ? 1 : 0;
            } else if (((IBattlePlayer)entityPlayer).isBlockingWithShield()) {
                renderer.field_78119_l = 3;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void resetPlayerLeftHand(RenderPlayerEvent.Post event) {
        event.renderer.func_177087_b().field_78119_l = 0;
    }

    @SubscribeEvent
    public void renderLiving(RenderLivingEvent.Post event) {
        if (BattlegearConfig.enableSkeletonQuiver && event.entity instanceof EntitySkeleton && event.renderer instanceof RenderSkeleton) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.quiverDetails);
            GlStateManager.func_179109_b((float)((float)event.x), (float)((float)event.y), (float)((float)event.z));
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
            float f2 = this.interpolateRotation(event.entity.field_70760_ar, event.entity.field_70761_aq, 0.0f);
            GlStateManager.func_179114_b((float)(180.0f - f2), (float)0.0f, (float)1.0f, (float)0.0f);
            if (event.entity.field_70725_aQ > 0) {
                float f3 = ((float)event.entity.field_70725_aQ + BattlegearClientTickHandeler.getPartialTick() - 1.0f) / 20.0f * 1.6f;
                if ((f3 = MathHelper.func_76129_c((float)f3)) > 1.0f) {
                    f3 = 1.0f;
                }
                GlStateManager.func_179114_b((float)(-f3 * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GlStateManager.func_179109_b((float)0.0f, (float)-1.5f, (float)0.0f);
            GlStateManager.func_179114_b((float)event.entity.field_70125_A, (float)0.0f, (float)1.0f, (float)0.0f);
            if (event.entity.func_71124_b(3) != null) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0625f);
            }
            ((ModelBiped)event.renderer.field_77045_g).field_78115_e.func_78794_c(0.0625f);
            GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.05f);
            this.quiverModel.render(5, 0.0625f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.quiverBase);
            GlStateManager.func_179124_c((float)0.1f, (float)0.1f, (float)0.1f);
            this.quiverModel.render(0, 0.0625f);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179089_o();
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public void onBowFOV(FOVUpdateEvent event) {
        ItemStack stack = event.entity.func_71011_bu();
        if (EnchantmentHelper.getEnchantmentLevel(BaseEnchantment.bowCharge, stack) > 0) {
            int i = event.entity.func_71057_bx();
            float f1 = (float)i / 20.0f;
            f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
            event.newfov /= 1.0f - f1 * 0.15f;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void replacePickBlock(MouseEvent event) {
        if (event.buttonstate) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g != null && event.button - 100 == mc.field_71474_y.field_74322_I.func_151463_i()) {
                event.setCanceled(true);
                if (!((IBattlePlayer)mc.field_71439_g).isBattlemode()) {
                    boolean isCreative = mc.field_71439_g.field_71075_bZ.field_75098_d;
                    ItemStack stack = BattlegearClientEvents.getItemFromPointedAt(mc.field_71476_x, (EntityPlayer)mc.field_71439_g);
                    if (stack != null) {
                        int k = -1;
                        for (int slot = 0; slot < MAIN_INV; ++slot) {
                            ItemStack temp = mc.field_71439_g.field_71071_by.func_70301_a(slot);
                            if (temp == null || !stack.func_77969_a(temp) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)temp)) continue;
                            k = slot;
                            break;
                        }
                        if (isCreative && k == -1 && ((k = mc.field_71439_g.field_71071_by.func_70447_i()) < 0 || k >= MAIN_INV)) {
                            k = mc.field_71439_g.field_71071_by.field_70461_c;
                        }
                        if (k >= 0 && k < MAIN_INV) {
                            mc.field_71439_g.field_71071_by.field_70461_c = k;
                            Battlegear.packetHandler.sendPacketToServer(new PickBlockPacket(stack, k).generatePacket());
                        }
                    }
                }
            }
        }
    }

    private static ItemStack getItemFromPointedAt(MovingObjectPosition target, EntityPlayer player) {
        if (target != null) {
            if (target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                BlockPos pos = target.func_178782_a();
                World world = player.func_130014_f_();
                Block block = world.func_180495_p(pos).func_177230_c();
                if (!block.isAir((IBlockAccess)world, pos)) {
                    TileEntity te;
                    ItemStack temp = block.getPickBlock(target, world, pos, player);
                    if (temp != null && player.field_71075_bZ.field_75098_d && GuiScreen.func_146271_m() && (te = world.func_175625_s(pos)) != null) {
                        NBTTagCompound nbt = new NBTTagCompound();
                        te.func_145841_b(nbt);
                        temp.func_77983_a("BlockEntityTag", (NBTBase)nbt);
                        NBTTagList lore = new NBTTagList();
                        lore.func_74742_a((NBTBase)new NBTTagString("(+NBT)"));
                        NBTTagCompound display = new NBTTagCompound();
                        display.func_74782_a("Lore", (NBTBase)lore);
                        temp.func_77983_a("display", (NBTBase)display);
                    }
                    return temp;
                }
            } else if (target.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && target.field_72308_g != null && player.field_71075_bZ.field_75098_d) {
                return target.field_72308_g.getPickedResult(target);
            }
        }
        return null;
    }

    public float interpolateRotation(float par1, float par2, float par3) {
        float f3;
        for (f3 = par2 - par1; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return par1 + par3 * f3;
    }

    @SubscribeEvent
    public void preStitch(TextureStitchEvent.Pre event) {
        ClientProxy.backgroundIcon = new TextureAtlasSprite[]{event.map.func_174942_a(new ResourceLocation("battlegear2:items/slots/mainhand")), event.map.func_174942_a(new ResourceLocation("battlegear2:items/slots/offhand"))};
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        for (String txt : event.toolTip) {
            if (!txt.startsWith(EnumChatFormatting.BLUE.toString())) continue;
            if (txt.contains(this.attributeNames[0]) || txt.contains(this.attributeNames[2])) {
                event.toolTip.set(event.toolTip.indexOf(txt), EnumChatFormatting.DARK_GREEN + EnumChatFormatting.func_110646_a((String)txt));
                continue;
            }
            if (txt.contains(this.attributeNames[3])) {
                event.toolTip.set(event.toolTip.indexOf(txt), EnumChatFormatting.DARK_GREEN + this.reformat(txt, 3));
                continue;
            }
            if (!txt.contains(this.attributeNames[1])) continue;
            event.toolTip.set(event.toolTip.indexOf(txt), EnumChatFormatting.GOLD + this.reformat(txt, 1));
        }
        if (event.itemStack.func_77973_b() instanceof IBackStabbable) {
            event.toolTip.add(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"attribute.name.weapon.backstab"));
        }
    }

    private String reformat(String txt, int type) {
        String result = EnumChatFormatting.func_110646_a((String)txt);
        Matcher matcher = FLOAT.matcher(result);
        if (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            String temp = result.substring(start, end).replace(",", ".");
            try {
                float value = Float.valueOf(temp).floatValue() * 100.0f;
                temp = ".plus.1";
                if (start > 0 && result.charAt(start - 1) == '-') {
                    temp = ".take.1";
                }
                return StatCollector.func_74837_a((String)("attribute.modifier" + temp), (Object[])new Object[]{ItemStack.field_111284_a.format(value), this.attributeNames[type]});
            }
            catch (NumberFormatException notNumber) {
                notNumber.printStackTrace();
            }
        }
        return result;
    }

    private String toLocal(BaseAttribute attribute) {
        return StatCollector.func_74838_a((String)("attribute.name." + attribute.func_111108_a()));
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.attributeNames = new String[]{this.toLocal((BaseAttribute)Attributes.armourPenetrate), this.toLocal((BaseAttribute)Attributes.daze), this.toLocal((BaseAttribute)Attributes.extendedReach), this.toLocal((BaseAttribute)Attributes.attackSpeed)};
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void postInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (Battlegear.battlegearEnabled && event.gui instanceof InventoryEffectRenderer && (!ClientProxy.tconstructEnabled || Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d)) {
            BattlegearClientEvents.onOpenGui(event.buttonList, ((InventoryEffectRenderer)event.gui).field_147003_i - 30, ((InventoryEffectRenderer)event.gui).field_147009_r);
        }
    }

    public static void onOpenGui(List<GuiButton> buttons, int guiLeft, int guiTop) {
        if (BattlegearConfig.enableGuiButtons) {
            int count = 0;
            for (GuiPlaceableButton tab : tabsList) {
                GuiPlaceableButton button = tab.copy();
                button.place(count, guiLeft, guiTop);
                button.field_146127_k = buttons.size() + 2;
                ++count;
                buttons.add(button);
            }
        }
    }
}

