/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import mods.battlegear2.Battlegear;
import mods.battlegear2.api.core.BattlegearUtils;
import mods.battlegear2.api.weapons.WeaponRegistry;
import mods.battlegear2.packet.WieldSetPacket;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.common.registry.GameData;

public final class CommandWeaponWield
extends CommandBase {
    public static final CommandWeaponWield INSTANCE = new CommandWeaponWield();
    public final String[] searchModes = new String[]{"current", "name", "sensitivity"};
    public final String[] operations = new String[]{"add", "remove", "get"};
    private Set<String> sensitivities = Sets.newHashSet((Object[])new String[]{"ID", "DAMAGE", "NBT"});

    private CommandWeaponWield() {
    }

    public String func_71517_b() {
        return "weaponwield";
    }

    public String func_71518_a(ICommandSender var1) {
        return "commands.weaponwield.usage";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_71515_b(ICommandSender var1, String[] var2) throws CommandException {
        if (var2 == null) return;
        ItemStack itemStack = null;
        if (var2.length == 2) {
            if (var2[0].equals(this.searchModes[0])) {
                if (!(var1 instanceof EntityPlayer)) throw new PlayerNotFoundException();
                itemStack = ((EntityPlayer)var1).func_71045_bC();
            } else if (var2[0].equals(this.searchModes[2]) && var2[1].equals(this.operations[2])) {
                CommandWeaponWield.func_152373_a((ICommandSender)var1, (ICommand)this, (String)"commands.weaponwield.sensitivity", (Object[])new Object[]{this.sensitivities});
                return;
            }
        } else if (var2.length < 5) {
            if (var2[0].equals(this.searchModes[0])) {
                itemStack = CommandWeaponWield.func_82359_c((ICommandSender)var1, (String)var2[2]).func_71045_bC();
            } else if (var2[0].equals(this.searchModes[1])) {
                Item item = CommandWeaponWield.func_147179_f((ICommandSender)var1, (String)var2[2]);
                if (item != null) {
                    itemStack = new ItemStack(item);
                }
            } else if (var2[0].equals(this.searchModes[2])) {
                WeaponRegistry.Sensitivity sens2;
                if (var2[1].equals(this.operations[0])) {
                    try {
                        sens2 = WeaponRegistry.Sensitivity.valueOf(var2[2].toUpperCase(Locale.ENGLISH));
                        if (this.sensitivities.add(sens2.name()) && WeaponRegistry.addSensitivity(sens2)) {
                            CommandWeaponWield.func_152373_a((ICommandSender)var1, (ICommand)this, (String)"commands.weaponwield.sensitivity.added", (Object[])new Object[]{sens2});
                            var1.func_145747_a((IChatComponent)new ChatComponentText(this.sensitivities.toString()));
                            return;
                        }
                    }
                    catch (IllegalArgumentException sens2) {}
                } else if (var2[1].equals(this.operations[1])) {
                    try {
                        sens2 = WeaponRegistry.Sensitivity.valueOf(var2[2].toUpperCase(Locale.ENGLISH));
                        if (this.sensitivities.remove(sens2.name()) && WeaponRegistry.removeSensitivity(sens2)) {
                            CommandWeaponWield.func_152373_a((ICommandSender)var1, (ICommand)this, (String)"commands.weaponwield.sensitivity.removed", (Object[])new Object[]{sens2});
                            var1.func_145747_a((IChatComponent)new ChatComponentText(this.sensitivities.toString()));
                            return;
                        }
                    }
                    catch (IllegalArgumentException sens3) {
                        // empty catch block
                    }
                }
            }
        }
        boolean result = false;
        if (itemStack != null) {
            String temp = var2[1].toUpperCase(Locale.ENGLISH);
            if (var2.length == 4 && CommandWeaponWield.func_180527_d((String)var2[3])) {
                result = this.setUsable(itemStack, temp);
            } else if (BattlegearUtils.checkForRightClickFunction(itemStack)) {
                result = this.setUsable(itemStack, temp);
            } else if (this.setWeapon(itemStack, temp)) {
                result = true;
            }
        }
        if (!result) throw new WrongUsageException(this.func_71518_a(var1), new Object[]{itemStack});
        var1.func_174794_a(CommandResultStats.Type.AFFECTED_ITEMS, itemStack.field_77994_a);
        CommandWeaponWield.func_152373_a((ICommandSender)var1, (ICommand)this, (String)"commands.weaponwield.set", (Object[])new Object[]{itemStack});
    }

    public boolean setWeapon(ItemStack stack, String type) {
        return WeaponRegistry.Wield.valueOf(type).setWeapon(stack);
    }

    public boolean setUsable(ItemStack stack, String type) {
        if (WeaponRegistry.Wield.valueOf(type).setUsable(stack)) {
            Battlegear.packetHandler.sendPacketToAll(new WieldSetPacket(stack, type).generatePacket());
            return true;
        }
        return false;
    }

    public List<String> func_180525_a(ICommandSender par1ICommandSender, String[] par2ArrayOfStr, BlockPos pos) {
        if (par2ArrayOfStr.length == 1) {
            return CommandWeaponWield.func_71530_a((String[])par2ArrayOfStr, (String[])this.searchModes);
        }
        if (par2ArrayOfStr.length == 2) {
            if (par2ArrayOfStr[0].equals(this.searchModes[0]) || par2ArrayOfStr[0].equals(this.searchModes[1])) {
                return CommandWeaponWield.func_71530_a((String[])par2ArrayOfStr, (String[])this.getNames((Object[])WeaponRegistry.Wield.values(), true));
            }
            if (par2ArrayOfStr[0].equals(this.searchModes[2])) {
                return CommandWeaponWield.func_71530_a((String[])par2ArrayOfStr, (String[])this.operations);
            }
        } else if (par2ArrayOfStr.length == 3) {
            if (par2ArrayOfStr[0].equals(this.searchModes[0])) {
                return CommandWeaponWield.func_71530_a((String[])par2ArrayOfStr, (String[])MinecraftServer.func_71276_C().func_71213_z());
            }
            if (par2ArrayOfStr[0].equals(this.searchModes[1])) {
                return CommandWeaponWield.func_175762_a((String[])par2ArrayOfStr, (Collection)GameData.getItemRegistry().func_148742_b());
            }
            if (par2ArrayOfStr[0].equals(this.searchModes[2])) {
                if (par2ArrayOfStr[1].equals(this.operations[0])) {
                    return CommandWeaponWield.func_175762_a((String[])par2ArrayOfStr, (Collection)Sets.difference((Set)ImmutableSet.copyOf((Object[])this.getNames(WeaponRegistry.Sensitivity.values(), false)), this.sensitivities));
                }
                if (par2ArrayOfStr[1].equals(this.operations[1])) {
                    return CommandWeaponWield.func_175762_a((String[])par2ArrayOfStr, this.sensitivities);
                }
            }
        } else if (par2ArrayOfStr.length == 4) {
            return CommandWeaponWield.func_71530_a((String[])par2ArrayOfStr, (String[])new String[]{"true", "1", "false", "0"});
        }
        return null;
    }

    private String[] getNames(Object[] values, boolean lowerCase) {
        String[] names = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            names[i] = values[i].toString();
            if (!lowerCase) continue;
            names[i] = names[i].toLowerCase(Locale.ENGLISH);
        }
        return names;
    }
}

