/*
 * Decompiled with CFR 0.152.
 */
package mods.mud;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import mods.battlegear2.WeaponHookContainerClass;
import mods.mud.ModUpdateDetectorTickHandeler;
import mods.mud.MudCommands;
import mods.mud.UpdateChecker;
import mods.mud.UpdateEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;

public class ModUpdateDetector {
    private static boolean hasInitialised = false;
    private static Map<String, UpdateEntry> updateMap;
    public static boolean hasChecked;
    private static int Timer;
    private static MinecraftServer server;

    public static void registerMod(ModContainer mc, URL updateXML, URL changelog) {
        if (!hasInitialised) {
            ModUpdateDetector.initialise();
            hasInitialised = true;
        }
        updateMap.put(mc.getModId(), new UpdateEntry(mc, updateXML, changelog));
    }

    public static void runUpdateChecker() {
        if (server == null || server != FMLCommonHandler.instance().getMinecraftServerInstance()) {
            server = FMLCommonHandler.instance().getMinecraftServerInstance();
            CommandHandler ch = (CommandHandler)server.func_71187_D();
            ch.func_71560_a((ICommand)new MudCommands());
        }
        ICommandSender sender = ModUpdateDetector.getSender();
        sender.func_70006_a(ChatMessageComponent.func_111066_d((String)(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"mud.name") + EnumChatFormatting.WHITE + ": " + StatCollector.func_74838_a((String)"message.checking"))));
        Thread t = new Thread(new UpdateChecker(updateMap.values()));
        t.run();
    }

    public static Collection<UpdateEntry> getAllUpdateEntries() {
        return updateMap.values();
    }

    private static void initialise() {
        updateMap = new HashMap<String, UpdateEntry>();
        TickRegistry.registerTickHandler((ITickHandler)new ModUpdateDetectorTickHandeler(Timer), (Side)Side.CLIENT);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)new WeaponHookContainerClass());
        }
    }

    public static ICommandSender getSender() {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            return Minecraft.func_71410_x().field_71439_g;
        }
        return MinecraftServer.func_71276_C();
    }

    public static void notifyUpdateDone() {
        ICommandSender sender = ModUpdateDetector.getSender();
        if (sender != null) {
            sender.func_70006_a(ChatMessageComponent.func_111066_d((String)(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"mud.name") + EnumChatFormatting.WHITE + ": " + StatCollector.func_74838_a((String)"message.check.done"))));
        }
        int outOfDateCount = 0;
        int failedCount = 0;
        for (UpdateEntry e : updateMap.values()) {
            try {
                if (e.isUpToDate()) continue;
                ++outOfDateCount;
            }
            catch (Exception e1) {
                ++failedCount;
            }
        }
        if (outOfDateCount > 0) {
            if (sender != null) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)String.format("%s%s %s %s", EnumChatFormatting.RED, StatCollector.func_74838_a((String)"message.you.have"), outOfDateCount, StatCollector.func_74838_a((String)"message.outdated"))));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)String.format("%s%s %s %s", EnumChatFormatting.RED, StatCollector.func_74838_a((String)"message.type"), "/mud", StatCollector.func_74838_a((String)"message.to.view"))));
            }
        } else if (sender != null) {
            sender.func_70006_a(ChatMessageComponent.func_111066_d((String)String.format("%s%s", EnumChatFormatting.DARK_GREEN, StatCollector.func_74838_a((String)"message.up.to.date"))));
        }
        hasChecked = true;
    }

    static {
        hasChecked = false;
        Timer = 72000;
    }
}

