/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.coremod.transformers;

import java.util.ListIterator;
import mods.battlegear2.coremod.BattlegearLoadingPlugin;
import mods.battlegear2.coremod.BattlegearTranslator;
import mods.battlegear2.coremod.transformers.TransformerUtils;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class NetClientHandlerTransformer
implements IClassTransformer {
    private String entityOtherPlayerMPClassName;
    private String playerInventoryFieldName;
    private String packet20NamedEntitySpawnClassName;
    private String netClientHandlerHandleNamedEntitySpawnMethodName;
    private String netClientHandlerHandleNamedEntitySpawnMethodDesc;
    private String netClientHandlerHandleBlockItemSwitchMethodName;
    private String netClientHandlerHandleBlockItemSwitchMethodDesc;

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.equals("net.minecraft.client.multiplayer.NetClientHandler")) {
            this.entityOtherPlayerMPClassName = BattlegearTranslator.getMapedClassName("EntityOtherPlayerMP");
            this.packet20NamedEntitySpawnClassName = BattlegearTranslator.getMapedClassName("Packet20NamedEntitySpawn");
            this.playerInventoryFieldName = BattlegearTranslator.getMapedFieldName("EntityPlayer", "field_71071_by");
            this.netClientHandlerHandleNamedEntitySpawnMethodName = BattlegearTranslator.getMapedMethodName("NetClientHandler", "func_72518_a");
            this.netClientHandlerHandleNamedEntitySpawnMethodDesc = BattlegearTranslator.getMapedMethodDesc("NetClientHandler", "func_72518_a");
            this.netClientHandlerHandleNamedEntitySpawnMethodName = BattlegearTranslator.getMapedMethodName("NetClientHandler", "func_72502_a");
            this.netClientHandlerHandleNamedEntitySpawnMethodDesc = BattlegearTranslator.getMapedMethodDesc("NetClientHandler", "func_72502_a");
            System.out.println("M&B - Patching Class NetClientHandler (" + name + ")");
            ClassReader cr = new ClassReader(bytes);
            ClassNode cn = new ClassNode(262144);
            cr.accept((ClassVisitor)cn, 0);
            for (Object mnObj : cn.methods) {
                MethodNode method = (MethodNode)mnObj;
                if (method.name.equals(this.netClientHandlerHandleNamedEntitySpawnMethodName) && method.desc.equals(this.netClientHandlerHandleNamedEntitySpawnMethodDesc)) {
                    System.out.println("\tPatching method handleNamedEntitySpawn in NetClientHandler");
                    TransformerUtils.replaceInventoryArrayAccess(method, this.entityOtherPlayerMPClassName, this.playerInventoryFieldName, 9, 13);
                    continue;
                }
                if (!method.name.equals(this.netClientHandlerHandleBlockItemSwitchMethodName) || !method.desc.equals(this.netClientHandlerHandleBlockItemSwitchMethodDesc)) continue;
                System.out.println("\tPatching method handleBlockItemSwitch in NetClientHandler");
                ListIterator insn = method.instructions.iterator();
                InsnList newList = new InsnList();
                while (insn.hasNext()) {
                    AbstractInsnNode nextNode = (AbstractInsnNode)insn.next();
                    if (nextNode instanceof JumpInsnNode && nextNode.getOpcode() == 155) {
                        LabelNode label = ((JumpInsnNode)nextNode).label;
                        newList.add((AbstractInsnNode)new MethodInsnNode(184, "mods/battlegear2/inventory/InventoryPlayerBattle", "isValidSwitch", "(I)Z"));
                        newList.add((AbstractInsnNode)new JumpInsnNode(153, label));
                        nextNode = (AbstractInsnNode)insn.next();
                        while (insn.hasNext() && !(nextNode instanceof JumpInsnNode) && nextNode.getOpcode() != 162) {
                            nextNode = (AbstractInsnNode)insn.next();
                        }
                        continue;
                    }
                    newList.add(nextNode);
                }
                method.instructions = newList;
            }
            ClassWriter cw = new ClassWriter(0);
            cn.accept((ClassVisitor)cw);
            System.out.println("M&B - Patching Class NetClientHandler (" + name + ") done");
            if (BattlegearLoadingPlugin.debug) {
                TransformerUtils.writeClassFile(cw, name);
            }
            return cw.toByteArray();
        }
        return bytes;
    }
}

