/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.coremod.transformers;

import mods.battlegear2.coremod.BattlegearLoadingPlugin;
import mods.battlegear2.coremod.BattlegearTranslator;
import mods.battlegear2.coremod.transformers.TransformerUtils;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ItemRendererTransformer
implements IClassTransformer {
    private String itemStackClass;
    private String itemRendererClass;
    private String minecraftClass;
    private String itemRendererMinecraftField;
    private String itemRendereriteToRenderField;
    private String renderItem1stPersonMethodName;
    private String renderItem1stPersonMethodDesc;
    private String updateEquippedItemMethodName;
    private String updateEquippedItemMethodDesc;

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.equals("net.minecraft.client.renderer.ItemRenderer")) {
            System.out.println("M&B - Patching Class ItemRenderer (" + name + ")");
            this.itemStackClass = BattlegearTranslator.getMapedClassName("ItemStack");
            this.itemRendererClass = BattlegearTranslator.getMapedClassName("ItemRenderer");
            this.minecraftClass = BattlegearTranslator.getMapedClassName("Minecraft");
            this.itemRendererMinecraftField = BattlegearTranslator.getMapedFieldName("ItemRenderer", "field_78455_a");
            this.itemRendereriteToRenderField = BattlegearTranslator.getMapedFieldName("ItemRenderer", "field_78453_b");
            this.renderItem1stPersonMethodName = BattlegearTranslator.getMapedMethodName("ItemRenderer", "func_78440_a");
            this.renderItem1stPersonMethodDesc = BattlegearTranslator.getMapedMethodDesc("ItemRenderer", "func_78440_a");
            this.updateEquippedItemMethodName = BattlegearTranslator.getMapedMethodName("ItemRenderer", "func_78441_a");
            this.updateEquippedItemMethodDesc = BattlegearTranslator.getMapedMethodDesc("ItemRenderer", "func_78441_a");
            ClassReader cr = new ClassReader(bytes);
            ClassNode cn = new ClassNode(262144);
            cr.accept((ClassVisitor)cn, 0);
            this.processFields(cn);
            for (Object mnObj : cn.methods) {
                MethodNode mn = (MethodNode)mnObj;
                if (mn.name.equals(this.renderItem1stPersonMethodName) && mn.desc.equals(this.renderItem1stPersonMethodDesc)) {
                    this.processRenderItemMethod(mn);
                    continue;
                }
                if (!mn.name.equals(this.updateEquippedItemMethodName) || !mn.desc.equals(this.updateEquippedItemMethodDesc)) continue;
                this.processupdateEquippedMethod(mn);
            }
            ClassWriter cw = new ClassWriter(0);
            cn.accept((ClassVisitor)cw);
            System.out.println("M&B - Patching Class ItemRenderer done");
            if (BattlegearLoadingPlugin.debug) {
                TransformerUtils.writeClassFile(cw, name);
            }
            return cw.toByteArray();
        }
        return bytes;
    }

    private void processupdateEquippedMethod(MethodNode mn) {
        System.out.println("\tPatching method updateEquippedItem in ItemRenderer");
        InsnList newList = new InsnList();
        for (AbstractInsnNode insn : mn.instructions) {
            if (insn.getOpcode() == 177) {
                newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newList.add((AbstractInsnNode)new FieldInsnNode(180, this.itemRendererClass, this.itemRendererMinecraftField, "L" + this.minecraftClass + ";"));
                newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newList.add((AbstractInsnNode)new FieldInsnNode(180, this.itemRendererClass, this.itemRendereriteToRenderField, "L" + this.itemStackClass + ";"));
                newList.add((AbstractInsnNode)new MethodInsnNode(184, "mods/battlegear2/client/utils/BattlegearRenderHelper", "updateEquippedItem", "(L" + this.itemRendererClass + ";L" + this.minecraftClass + ";L" + this.itemStackClass + ";)V"));
            }
            newList.add(insn);
        }
        mn.instructions = newList;
    }

    private void processRenderItemMethod(MethodNode mn) {
        System.out.println("\tPatching method renderItemInFirstPerson in ItemRenderer");
        InsnList newList = new InsnList();
        for (AbstractInsnNode insn : mn.instructions) {
            if (insn.getOpcode() == 177) {
                newList.add((AbstractInsnNode)new VarInsnNode(23, 1));
                newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newList.add((AbstractInsnNode)new FieldInsnNode(180, this.itemRendererClass, this.itemRendererMinecraftField, "L" + this.minecraftClass + ";"));
                newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newList.add((AbstractInsnNode)new FieldInsnNode(180, this.itemRendererClass, "offHandItemToRender", "L" + this.itemStackClass + ";"));
                newList.add((AbstractInsnNode)new MethodInsnNode(184, "mods/battlegear2/client/utils/BattlegearRenderHelper", "renderItemInFirstPerson", "(FL" + this.minecraftClass + ";L" + this.itemRendererClass + ";L" + this.itemStackClass + ";)V"));
            }
            newList.add(insn);
        }
        mn.instructions = newList;
    }

    private void processFields(ClassNode cn) {
        System.out.println("\tAdding new fields to ItemRenderer");
        cn.fields.add(0, new FieldNode(1, "offHandItemToRender", "L" + this.itemStackClass + ";", null, null));
        cn.fields.add(1, new FieldNode(1, "equippedItemOffhandSlot", "I", null, (Object)0));
        cn.fields.add(2, new FieldNode(1, "equippedOffHandProgress", "F", null, (Object)Float.valueOf(0.0f)));
        cn.fields.add(3, new FieldNode(1, "prevEquippedOffHandProgress", "F", null, (Object)Float.valueOf(0.0f)));
    }
}

