/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client.renderer;

import mods.battlegear2.BowHookContainerClass2;
import mods.battlegear2.api.quiver.IArrowContainer2;
import mods.battlegear2.client.ClientProxy;
import mods.battlegear2.client.renderer.SpearRenderer;
import mods.battlegear2.client.utils.BattlegearRenderHelper;
import mods.battlegear2.items.ItemMBArrow;
import mods.battlegear2.utils.BattlegearConfig;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class BowRenderer
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case EQUIPPED_FIRST_PERSON: {
                this.renderEquippedBow(item, (EntityLivingBase)data[1], true);
                break;
            }
            case EQUIPPED: {
                this.renderEquippedBow(item, (EntityLivingBase)data[1], false);
            }
        }
    }

    private void renderEquippedBow(ItemStack item, EntityLivingBase entityLivingBase, boolean firstPerson) {
        Icon icon = item.func_77954_c();
        ItemStack arrowStack = new ItemStack(Item.field_77704_l);
        int drawAmount = -2;
        if (entityLivingBase instanceof EntityPlayer) {
            ItemStack quiver;
            EntityPlayer player = (EntityPlayer)entityLivingBase;
            if (player.func_71011_bu() != null) {
                int timer = item.func_77988_m() - player.func_71052_bv();
                if (timer >= 18) {
                    drawAmount = 2;
                } else if (timer > 13) {
                    drawAmount = 1;
                } else if (timer > 0) {
                    drawAmount = 0;
                }
            }
            if ((quiver = BowHookContainerClass2.getArrowContainer(item, (EntityPlayer)entityLivingBase)) != null) {
                arrowStack = ((IArrowContainer2)quiver.func_77973_b()).getStackInSlot(quiver, ((IArrowContainer2)quiver.func_77973_b()).getSelectedSlot(quiver));
            }
            if (drawAmount >= 0) {
                icon = arrowStack != null && (arrowStack.func_77973_b() instanceof ItemMBArrow || arrowStack.func_77973_b().field_77779_bT == Item.field_77704_l.field_77779_bT) ? ClientProxy.bowIcons[drawAmount] : Item.field_77707_k.func_94599_c(drawAmount);
            }
        } else if (entityLivingBase instanceof EntitySkeleton) {
            byte type = entityLivingBase.func_70096_w().func_75683_a(25);
            if (type > -1) {
                arrowStack = new ItemStack(BattlegearConfig.MbArrows, 1, (int)type);
            }
        } else if (entityLivingBase == null || entityLivingBase.equals((Object)BattlegearRenderHelper.dummyEntity)) {
            arrowStack = null;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        ItemRenderer.func_78439_a((Tessellator)tessellator, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
        if (arrowStack != null && (arrowStack.func_77973_b() instanceof ItemMBArrow || arrowStack.func_77973_b().field_77779_bT == Item.field_77704_l.field_77779_bT)) {
            icon = arrowStack.func_77954_c();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(-(-3.0f + (float)drawAmount) / 16.0f), (float)(-(-2.0f + (float)drawAmount) / 16.0f), (float)(firstPerson ? -0.03125f : 0.03125f));
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)icon.func_94209_e(), (float)icon.func_94206_g(), (float)icon.func_94212_f(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
            GL11.glPopMatrix();
        }
        if (item.func_77948_v()) {
            SpearRenderer.renderEnchantmentEffects(tessellator);
        }
    }
}

