/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.enchantments;

import java.util.ArrayList;
import java.util.List;
import mods.battlegear2.api.IEnchantable;
import mods.battlegear2.utils.BattlegearConfig;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.item.ItemStack;

public class BaseEnchantment
extends Enchantment {
    private static List<Enchantment> enchants = new ArrayList<Enchantment>();
    private int max;
    private int enchantCoeff;
    private int range;
    public static final Enchantment bashWeight = new BaseEnchantment(BattlegearConfig.enchantsId[0], 5, 3, 15, 30).func_77322_b("bash.weightless");
    public static final Enchantment bashPower = new BaseEnchantment(BattlegearConfig.enchantsId[1], 10, 5, 10, 40).func_77322_b("bash.power");
    public static final Enchantment bashDamage = new BaseEnchantment(BattlegearConfig.enchantsId[2], 1, 3, 15, 50).func_77322_b("bash.damage");
    public static final Enchantment shieldUsage = new BaseEnchantment(BattlegearConfig.enchantsId[3], 2, 5, 5, 30).func_77322_b("shield.usage");
    public static final Enchantment shieldRecover = new BaseEnchantment(BattlegearConfig.enchantsId[4], 3, 4, 20, 20).func_77322_b("shield.recover");
    public static final Enchantment bowLoot = new BaseEnchantment(BattlegearConfig.enchantsId[5], 2, EnumEnchantmentType.bow, 10, 50).func_77322_b("bow.loot");
    public static final Enchantment bowCharge = new BaseEnchantment(BattlegearConfig.enchantsId[6], 1, EnumEnchantmentType.bow, 20, 20).func_77322_b("bow.charge");

    public BaseEnchantment(int id, int weight, int limit, int progress, int range) {
        super(id, weight, EnumEnchantmentType.all);
        this.max = limit > 1 ? limit : 1;
        this.enchantCoeff = progress > 1 ? progress : 1;
        this.range = range > 0 ? range : 0;
        enchants.add(this);
        BaseEnchantment.addToBookList((Enchantment)this);
    }

    public BaseEnchantment(int id, int weight, EnumEnchantmentType type, int coeff, int rng) {
        super(id, weight, type);
        this.max = 1;
        this.enchantCoeff = coeff > 1 ? coeff : 1;
        this.range = this.range > 0 ? rng : 0;
        enchants.add(this);
        BaseEnchantment.addToBookList((Enchantment)this);
    }

    public boolean func_92089_a(ItemStack stack) {
        if (this.field_77351_y == EnumEnchantmentType.all) {
            if (stack.func_77973_b() instanceof IEnchantable) {
                return ((IEnchantable)stack.func_77973_b()).isEnchantable(this, stack);
            }
        } else {
            return super.func_92089_a(stack);
        }
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.func_92089_a(stack);
    }

    public int func_77325_b() {
        return this.max;
    }

    public boolean func_77326_a(Enchantment par1Enchantment) {
        return super.func_77326_a(par1Enchantment) && par1Enchantment.field_77352_x != this.field_77352_x;
    }

    public int func_77321_a(int par1) {
        return 1 + par1 * this.enchantCoeff;
    }

    public int func_77317_b(int par1) {
        return this.func_77321_a(par1) + this.range;
    }

    public static List<Enchantment> getEnchants() {
        return enchants;
    }
}

