/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client.gui.controls;

import mods.battlegear2.api.heraldry.HeraldryData;
import mods.battlegear2.api.heraldry.PatternStore;
import mods.battlegear2.api.heraldry.RefreshableTexture;
import mods.battlegear2.client.gui.BattlegearSigilGUI;
import mods.battlegear2.client.gui.controls.GUIScrollList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiPatternScrollList
extends GUIScrollList {
    private RefreshableTexture[] dynamicTextures;
    private boolean dirtyTextures = true;
    BattlegearSigilGUI parent;

    public GuiPatternScrollList(BattlegearSigilGUI parent, int width, int top, int bottom, int left) {
        super(width, top + 20, bottom - 20, left, 20);
        this.parent = parent;
        this.dynamicTextures = new RefreshableTexture[PatternStore.DEFAULT.patterns.get(parent.getCurrentData().getPatternIndex()).length];
        for (int i = 0; i < this.dynamicTextures.length; ++i) {
            this.dynamicTextures[i] = new RefreshableTexture(32, 32);
        }
    }

    public void markAllDirty() {
        this.dirtyTextures = true;
    }

    @Override
    protected int getSize() {
        return PatternStore.DEFAULT.patterns.get(this.parent.getCurrentData().getPatternIndex()).length;
    }

    @Override
    protected void elementClicked(int index, boolean doubleClick) {
        this.parent.getCurrentData().setPattern(index);
        this.parent.markAllDirty();
    }

    @Override
    protected boolean isSelected(int index) {
        return index == this.parent.getCurrentData().getPattern();
    }

    @Override
    protected void drawBackground() {
        GuiPatternScrollList.drawRect(this.left, this.top - 20, this.left + this.listWidth, this.bottom + 20, -1442840576);
        GuiPatternScrollList.drawRect(this.left, this.parent.field_73881_g, this.left + this.listWidth, 0, 0x44000000);
    }

    @Override
    protected void drawSlot(int var1, int var2, int var3, int var4, Tessellator var5) {
        if (this.dirtyTextures) {
            HeraldryData heraldryData = this.parent.getCurrentData().clone();
            for (int i = 0; i < this.dynamicTextures.length; ++i) {
                heraldryData.setPattern(i);
                this.dynamicTextures[i].refreshWith(heraldryData, true);
            }
            this.dirtyTextures = false;
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)771);
        GL11.glDisable((int)3008);
        this.dynamicTextures[var1].func_110564_a();
        ResourceLocation rl = Minecraft.func_71410_x().func_110434_K().func_110578_a("gui_dynamic_pattern_" + var1, (DynamicTexture)this.dynamicTextures[var1]);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(rl);
        this.drawTexturedModalRect(var5, var2 - this.listWidth / 2 - 8, var3, 16, 16, 0);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
    }
}

