/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2;

import java.util.Random;
import mods.battlegear2.api.PlayerEventChild;
import mods.battlegear2.api.core.InventoryPlayerBattle;
import mods.battlegear2.api.quiver.IArrowContainer2;
import mods.battlegear2.api.quiver.IQuiverSelection;
import mods.battlegear2.api.quiver.QuiverArrowRegistry;
import mods.battlegear2.enchantments.BaseEnchantment;
import mods.battlegear2.items.arrows.AbstractMBArrow;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;

public class BowHookContainerClass2 {
    public BowHookContainerClass2() {
        QuiverArrowRegistry.addQuiverSelection(new OffhandQuiverSelection());
        QuiverArrowRegistry.addQuiverSelection(new MainQuiverSelection());
    }

    @ForgeSubscribe(receiveCanceled=true)
    public void onBowUse(ArrowNockEvent event) {
        ItemStack quiver;
        boolean canDrawBow = false;
        if (event.entityPlayer.field_71075_bZ.field_75098_d || event.entityPlayer.field_71071_by.func_70450_e(Item.field_77704_l.field_77779_bT)) {
            canDrawBow = true;
        }
        if (!canDrawBow && (quiver = QuiverArrowRegistry.getArrowContainer(event.result, event.entityPlayer)) != null && ((IArrowContainer2)quiver.func_77973_b()).hasArrowFor(quiver, event.result, event.entityPlayer, ((IArrowContainer2)quiver.func_77973_b()).getSelectedSlot(quiver))) {
            canDrawBow = true;
        }
        if (canDrawBow) {
            event.entityPlayer.func_71008_a(event.result, event.result.func_77973_b().func_77626_a(event.result) - EnchantmentHelper.func_77506_a((int)BaseEnchantment.bowCharge.field_77352_x, (ItemStack)event.result) * 20000);
            event.setCanceled(true);
        }
    }

    public static boolean isLoadedContainer(ItemStack item, ItemStack bow, EntityPlayer entityPlayer) {
        if (item != null && item.func_77973_b() instanceof IArrowContainer2) {
            int maxSlot = ((IArrowContainer2)item.func_77973_b()).getSlotCount(item);
            for (int i = 0; i < maxSlot; ++i) {
                if (!((IArrowContainer2)item.func_77973_b()).hasArrowFor(item, bow, entityPlayer, i)) continue;
                return true;
            }
        }
        return false;
    }

    @ForgeSubscribe(receiveCanceled=true)
    public void onBowFiring(ArrowLooseEvent event) {
        World world;
        IArrowContainer2 quiver;
        EntityArrow entityarrow;
        ItemStack stack;
        float f = new PlayerEventChild.QuiverArrowEvent.ChargeCalculations(event).getCharge();
        if (f > 0.0f && (stack = QuiverArrowRegistry.getArrowContainer(event.bow, event.entityPlayer)) != null && (entityarrow = (quiver = (IArrowContainer2)stack.func_77973_b()).getArrowType(stack, world = event.entityPlayer.field_70170_p, event.entityPlayer, f * 2.0f)) != null) {
            PlayerEventChild.QuiverArrowEvent.Firing arrowEvent = new PlayerEventChild.QuiverArrowEvent.Firing(event, stack, entityarrow);
            quiver.onPreArrowFired(arrowEvent);
            if (!MinecraftForge.EVENT_BUS.post((Event)arrowEvent)) {
                if (arrowEvent.isCritical || f == 1.0f) {
                    entityarrow.func_70243_d(true);
                }
                if (arrowEvent.addEnchantments) {
                    int l;
                    int k = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)event.bow);
                    if (k > 0) {
                        entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)k * 0.5 + 0.5);
                    }
                    if ((l = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)event.bow)) > 0) {
                        entityarrow.func_70240_a(l);
                    }
                    if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)event.bow) > 0) {
                        entityarrow.func_70015_d(100);
                    }
                }
                if (arrowEvent.bowDamage > 0) {
                    event.bow.func_77972_a(arrowEvent.bowDamage, (EntityLivingBase)event.entityPlayer);
                }
                if (arrowEvent.bowSoundVolume > 0.0f) {
                    world.func_72956_a((Entity)event.entityPlayer, "random.bow", arrowEvent.bowSoundVolume, 1.0f / (new Random().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                }
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)entityarrow);
                }
                quiver.onArrowFired(world, event.entityPlayer, stack, event.bow, entityarrow);
                event.setCanceled(true);
            }
        }
    }

    @ForgeSubscribe
    public void onEntityHitByArrow(LivingAttackEvent event) {
        if (event.source.func_76352_a() && event.source.func_76364_f() instanceof AbstractMBArrow) {
            boolean isCanceled = ((AbstractMBArrow)event.source.func_76364_f()).onHitEntity(event.entity, event.source, event.ammount);
            event.setCanceled(isCanceled);
        }
    }

    public static class MainQuiverSelection
    implements IQuiverSelection {
        @Override
        public ItemStack getQuiverFor(ItemStack bow, EntityPlayer player) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack temp = player.field_71071_by.func_70301_a(i);
                if (temp == null || !BowHookContainerClass2.isLoadedContainer(temp, bow, player)) continue;
                return temp;
            }
            return null;
        }
    }

    public static class OffhandQuiverSelection
    implements IQuiverSelection {
        @Override
        public ItemStack getQuiverFor(ItemStack bow, EntityPlayer player) {
            ItemStack offhand = ((InventoryPlayerBattle)player.field_71071_by).getCurrentOffhandWeapon();
            return BowHookContainerClass2.isLoadedContainer(offhand, bow, player) ? offhand : null;
        }
    }
}

