/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.FMLInjectionData;
import java.net.URL;
import java.util.logging.Logger;
import mods.battlegear2.BgPlayerTracker;
import mods.battlegear2.CommonProxy;
import mods.battlegear2.api.core.BattlegearTranslator;
import mods.battlegear2.api.core.BattlegearUtils;
import mods.battlegear2.api.quiver.IArrowFireHandler;
import mods.battlegear2.api.quiver.IQuiverSelection;
import mods.battlegear2.api.quiver.QuiverArrowRegistry;
import mods.battlegear2.api.weapons.WeaponRegistry;
import mods.battlegear2.gui.BattlegearGUIHandeler;
import mods.battlegear2.items.ItemMBArrow;
import mods.battlegear2.packet.BattlegearPacketHandeler;
import mods.battlegear2.recipies.CraftingHandeler;
import mods.battlegear2.utils.BattlegearConfig;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.EnumHelper;

@Mod(modid="battlegear2", useMetadata=true)
@NetworkMod(clientSideRequired=true, channels={"MB2|Animation", "MB2|SyncItem", "MB2|Banner", "MB2|Heraldry", "MB2|GUI", "MB2|Block", "MB2|ShieldFlash", "MB2|Special", "MB|Login", "MB2|Place", "MB2|CreaPick"}, packetHandler=BattlegearPacketHandeler.class)
public class Battlegear {
    @Mod.Instance(value="battlegear2")
    public static Battlegear INSTANCE;
    @SidedProxy(clientSide="mods.battlegear2.client.ClientProxy", serverSide="mods.battlegear2.CommonProxy")
    public static CommonProxy proxy;
    public static String imageFolder;
    public static final String CUSTOM_DAMAGE_SOURCE = "battlegearExtra";
    public static EnumArmorMaterial knightArmourMaterial;
    public static boolean battlegearEnabled;
    public static boolean debug;
    public static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        BattlegearTranslator.setup("/deobfuscation_data-" + FMLInjectionData.data()[4] + ".lzma");
        knightArmourMaterial = EnumHelper.addArmorMaterial((String)"knights.armour", (int)25, (int[])new int[]{3, 7, 5, 3}, (int)15);
        BattlegearConfig.getConfig(new Configuration(event.getSuggestedConfigurationFile()));
        if ((event.getSourceFile().getName().endsWith(".jar") || debug) && event.getSide().isClient()) {
            try {
                Class.forName("mods.mud.ModUpdateDetector").getDeclaredMethod("registerMod", ModContainer.class, URL.class, URL.class).invoke(null, FMLCommonHandler.instance().findContainerFor((Object)this), new URL("https://raw.github.com/Mine-and-blade-admin/Battlegear2/master/battlegear_update.xml"), new URL("https://raw.github.com/Mine-and-blade-admin/Battlegear2/master/changelog.md"));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        logger = event.getModLog();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        BattlegearConfig.registerRecipes();
        GameRegistry.registerCraftingHandler((ICraftingHandler)new CraftingHandeler());
        QuiverArrowRegistry.addArrowToRegistry(Item.field_77704_l.field_77779_bT, 0, EntityArrow.class);
        if (BattlegearConfig.MbArrows != null) {
            for (int i = 0; i < ItemMBArrow.arrows.length; ++i) {
                QuiverArrowRegistry.addArrowToRegistry(BattlegearConfig.MbArrows.field_77779_bT, i, ItemMBArrow.arrows[i]);
            }
        }
        proxy.registerKeyHandelers();
        proxy.registerTickHandelers();
        proxy.registerItemRenderers();
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)new BattlegearGUIHandeler());
        GameRegistry.registerPlayerTracker((IPlayerTracker)new BgPlayerTracker());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (Loader.isModLoaded((String)"TConstruct")) {
            proxy.tryUseTConstruct();
        }
    }

    @Mod.EventHandler
    public void onMessage(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (message == null) continue;
            boolean success = false;
            if (message.isItemStackMessage()) {
                ItemStack stack = message.getItemStackValue();
                if (stack != null) {
                    if (message.key.equals("Dual")) {
                        if (!BattlegearUtils.checkForRightClickFunction(stack.func_77973_b(), stack)) {
                            WeaponRegistry.addDualWeapon(stack);
                            success = true;
                        }
                    } else if (message.key.equals("MainHand")) {
                        WeaponRegistry.addTwoHanded(stack);
                        success = true;
                    } else if (message.key.equals("OffHand")) {
                        if (!BattlegearUtils.checkForRightClickFunction(stack.func_77973_b(), stack)) {
                            WeaponRegistry.addOffhandWeapon(stack);
                            success = true;
                        }
                    } else if (message.key.startsWith("Arrow:")) {
                        Class<?> clazz = null;
                        try {
                            clazz = Class.forName(message.key.split(":")[1]);
                        }
                        catch (ClassNotFoundException ignored) {
                            // empty catch block
                        }
                        if (clazz != null && EntityArrow.class.isAssignableFrom(clazz)) {
                            QuiverArrowRegistry.addArrowToRegistry(stack, clazz);
                            success = true;
                        }
                    }
                }
            } else if (message.isStringMessage()) {
                try {
                    Class<?> clazz = Class.forName(message.getStringValue());
                    if (clazz != null) {
                        if (message.key.equals("QuiverSelection") && IQuiverSelection.class.isAssignableFrom(clazz)) {
                            QuiverArrowRegistry.addQuiverSelection((IQuiverSelection)clazz.newInstance());
                            success = true;
                        } else if (message.key.equals("FireHandler") && IArrowFireHandler.class.isAssignableFrom(clazz)) {
                            QuiverArrowRegistry.addArrowFireHandler((IArrowFireHandler)clazz.newInstance());
                            success = true;
                        }
                    }
                }
                catch (Exception logged) {
                    // empty catch block
                }
            }
            if (success) {
                logger.finest("Mine&Blade:Battlegear2 successfully managed message from " + message.getSender());
                continue;
            }
            logger.warning(message.getSender() + " tried to communicate with Mine&Blade:Battlegear2, but message was not supported!");
        }
    }

    static {
        imageFolder = "battlegear2:textures/";
        battlegearEnabled = true;
        debug = false;
    }
}

