/*
 * Decompiled with CFR 0.152.
 */
package net.reimaden.arcadiandream.item.custom.danmaku;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.reimaden.arcadiandream.entity.custom.danmaku.BaseBulletEntity;
import org.jetbrains.annotations.NotNull;

public interface BulletPatterns {
    default public void createSpread(class_1937 world, class_1657 user, class_1799 stack, int density, float speed, float divergence) {
        float pitch = user.method_36455();
        float yaw = user.method_36454();
        for (int i = 0; i < density; ++i) {
            BaseBulletEntity bulletEntity = this.getBullet(world, (class_1309)user);
            bulletEntity.method_16940(stack);
            bulletEntity.method_24919((class_1297)user, pitch, yaw, 0.0f, speed, divergence + (float)density - 1.0f);
            world.method_8649((class_1297)bulletEntity);
        }
    }

    default public void createRay(class_1937 world, class_1657 user, class_1799 stack, int density, float speed, float divergence, float n) {
        float pitch = user.method_36455();
        float yaw = user.method_36454();
        for (int i = 0; i < density; ++i) {
            BaseBulletEntity bulletEntity = this.getBullet(world, (class_1309)user);
            bulletEntity.method_16940(stack);
            bulletEntity.method_24919((class_1297)user, pitch, yaw, 0.0f, speed, divergence);
            world.method_8649((class_1297)bulletEntity);
            speed -= n;
        }
    }

    default public void createRing(class_1937 world, class_1657 user, class_1799 stack, int density, float speed, float divergence) {
        float pitch = user.method_36455();
        float yaw = user.method_36454();
        for (int i = 0; i < density; ++i) {
            BaseBulletEntity bulletEntity = this.getBullet(world, (class_1309)user);
            bulletEntity.method_16940(stack);
            float angle = (float)i * (360.0f / (float)density) + 180.0f;
            class_243 bullet = new class_243(0.0, 0.0, 1.0);
            bullet = bullet.method_1024(angle * ((float)Math.PI / 180));
            bullet = bullet.method_1037(pitch * ((float)Math.PI / 180));
            bullet = bullet.method_1024((-yaw + 180.0f) * ((float)Math.PI / 180));
            bulletEntity.method_7485(bullet.method_10216(), bullet.method_10214(), bullet.method_10215(), speed, divergence);
            world.method_8649((class_1297)bulletEntity);
        }
    }

    default public void createArc(class_1937 world, class_1657 user, class_1799 stack, int density, float speed, float divergence) {
        float pitch = user.method_36455();
        float yaw = user.method_36454();
        float arc = 45.0f;
        for (int i = 0; i < density; ++i) {
            BaseBulletEntity bulletEntity = this.getBullet(world, (class_1309)user);
            bulletEntity.method_16940(stack);
            float angle = (float)i * (45.0f / (float)(density - 1));
            class_243 bullet = new class_243(0.0, 0.0, 1.0);
            bullet = bullet.method_1024((angle + 157.5f) * ((float)Math.PI / 180));
            bullet = bullet.method_1037(pitch * ((float)Math.PI / 180));
            bullet = bullet.method_1024((-yaw + 180.0f) * ((float)Math.PI / 180));
            bulletEntity.method_7485(bullet.method_10216(), bullet.method_10214(), bullet.method_10215(), speed, divergence);
            world.method_8649((class_1297)bulletEntity);
        }
    }

    default public void createDouble(class_1937 world, class_1657 user, class_1799 stack, int density, float speed, float divergence, float n) {
        float pitch = user.method_36455();
        float yaw = user.method_36454();
        float spread = 22.5f;
        int rays = Math.min(density, 2);
        block0: for (int j = 0; j < rays; ++j) {
            float s = speed;
            int i = 0;
            while (true) {
                double d = i;
                double d2 = density <= 2 ? Math.ceil((float)density / 2.0f) : Math.floor((float)density / 2.0f);
                if (!(d < d2)) continue block0;
                BaseBulletEntity bulletEntity = this.getBullet(world, (class_1309)user);
                bulletEntity.method_16940(stack);
                float angle = 22.5f * (float)j - 11.25f;
                class_243 bullet = new class_243(0.0, 0.0, 1.0);
                bullet = bullet.method_1024((angle + 180.0f) * ((float)Math.PI / 180));
                bullet = bullet.method_1037(pitch * ((float)Math.PI / 180));
                bullet = bullet.method_1024((-yaw + 180.0f) * ((float)Math.PI / 180));
                bulletEntity.method_7485(bullet.method_10216(), bullet.method_10214(), bullet.method_10215(), s, divergence);
                world.method_8649((class_1297)bulletEntity);
                s -= n;
                ++i;
            }
        }
    }

    default public void createTriple(class_1937 world, class_1657 user, class_1799 stack, int density, float speed, float divergence, float n) {
        float pitch = user.method_36455();
        float yaw = user.method_36454();
        float spread = 15.0f;
        int rays = Math.min(density, 3);
        block0: for (int j = 0; j < rays; ++j) {
            float s = speed;
            int i = 0;
            while (true) {
                double d = i;
                double d2 = density <= 3 ? Math.ceil((float)density / 3.0f) : Math.floor((float)density / 3.0f);
                if (!(d < d2)) continue block0;
                BaseBulletEntity bulletEntity = this.getBullet(world, (class_1309)user);
                bulletEntity.method_16940(stack);
                float angle = 15.0f * (float)j - 15.0f;
                class_243 bullet = new class_243(0.0, 0.0, 1.0);
                bullet = bullet.method_1024((angle + 180.0f) * ((float)Math.PI / 180));
                bullet = bullet.method_1037(pitch * ((float)Math.PI / 180));
                bullet = bullet.method_1024((-yaw + 180.0f) * ((float)Math.PI / 180));
                bulletEntity.method_7485(bullet.method_10216(), bullet.method_10214(), bullet.method_10215(), s, divergence);
                world.method_8649((class_1297)bulletEntity);
                s -= n;
                ++i;
            }
        }
    }

    @NotNull
    public BaseBulletEntity getBullet(class_1937 var1, class_1309 var2);
}

