/*
 * Decompiled with CFR 0.152.
 */
package net.reimaden.arcadiandream.item.custom.danmaku;

import java.util.List;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3468;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.reimaden.arcadiandream.ArcadianDream;
import net.reimaden.arcadiandream.entity.custom.danmaku.BaseBulletEntity;
import net.reimaden.arcadiandream.item.custom.danmaku.BulletPatterns;
import net.reimaden.arcadiandream.item.custom.danmaku.DyeableBullet;
import net.reimaden.arcadiandream.sound.ModSounds;
import net.reimaden.arcadiandream.util.ColorMap;
import net.reimaden.arcadiandream.util.ModTags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseShotItem
extends class_1792
implements DyeableBullet,
BulletPatterns {
    private static final class_5819 RANDOM = class_5819.method_43047();
    private final float power;
    private final float speed;
    private final int duration;
    private final int cooldown;
    private final float gravity;
    private final float divergence;
    private final String pattern;
    private final int density;
    private final boolean timeOrbUsed;
    private final boolean icy;
    private final float maxPower;
    private final float maxSpeed;
    private final int maxDuration;
    private final int maxCooldown;
    private final float maxGravity;
    private final float maxDivergence;
    private final int maxDensity;

    public BaseShotItem(class_1792.class_1793 settings, float power, float speed, int duration, int cooldown, float gravity, float divergence, String pattern, int density, float maxPower, float maxSpeed, int maxDuration, int maxCooldown, float maxDivergence, int maxDensity) {
        super(settings);
        this.power = power;
        this.speed = speed;
        this.duration = duration;
        this.cooldown = cooldown;
        this.gravity = gravity;
        this.divergence = divergence;
        this.pattern = pattern;
        this.density = density;
        this.timeOrbUsed = false;
        this.icy = false;
        this.maxPower = maxPower;
        this.maxSpeed = maxSpeed;
        this.maxDuration = maxDuration;
        this.maxCooldown = maxCooldown;
        this.maxDivergence = maxDivergence;
        this.maxDensity = maxDensity;
        this.maxGravity = 1.0f;
    }

    public static boolean isUsable(class_1799 stack) {
        return stack.method_7919() < stack.method_7936() - 1;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        class_2487 nbt = stack.method_7948();
        if (!BaseShotItem.isUsable(stack)) {
            return class_1271.method_22430((Object)stack);
        }
        int cooldown = nbt.method_10550("cooldown") * ArcadianDream.CONFIG.danmakuCooldownMultiplier() / (this.isTimeOrbUsed(stack) ? 2 : 1);
        user.method_5783(ModSounds.ENTITY_DANMAKU_FIRE, BaseShotItem.getSoundVolume(), BaseShotItem.getSoundPitch(RANDOM));
        if (ArcadianDream.CONFIG.cooldownPerBulletType()) {
            user.method_7357().method_7906((class_1792)this, cooldown);
        } else {
            for (class_1792 item : ModTags.SHOTS) {
                user.method_7357().method_7906(item, cooldown);
            }
        }
        int density = nbt.method_10550("density");
        float speed = nbt.method_10583("speed");
        float divergence = nbt.method_10583("divergence");
        float n = speed / (float)density;
        if (!world.method_8608()) {
            this.fireShot(world, user, stack, nbt, density, speed, divergence, n);
        }
        user.method_7259(class_3468.field_15372.method_14956((Object)this));
        if (!user.method_31549().field_7477 && BaseShotItem.isUsable(stack)) {
            int currentDamage;
            int damage = 1 + density / 4;
            int maxDamage = stack.method_7936();
            stack.method_7956(damage >= maxDamage - (currentDamage = stack.method_7919()) ? maxDamage - currentDamage - 1 : damage, (class_1309)user, e -> e.method_20236(hand));
        }
        return class_1271.method_29237((Object)stack, (boolean)world.method_8608());
    }

    private void fireShot(class_1937 world, class_1657 user, class_1799 stack, class_2487 nbt, int density, float speed, float divergence, float n) {
        switch (nbt.method_10558("pattern").toLowerCase()) {
            case "spread": {
                this.createSpread(world, user, stack, density, speed, divergence);
                break;
            }
            case "ray": {
                this.createRay(world, user, stack, density, speed, divergence, n);
                break;
            }
            case "ring": {
                this.createRing(world, user, stack, density, speed, divergence);
                break;
            }
            case "arc": {
                this.createArc(world, user, stack, density, speed, divergence);
                break;
            }
            case "double": {
                this.createDouble(world, user, stack, density, speed, divergence, n);
                break;
            }
            case "triple": {
                this.createTriple(world, user, stack, density, speed, divergence, n);
                break;
            }
            default: {
                throw new IllegalArgumentException("No valid bullet pattern found!");
            }
        }
    }

    public static float getSoundPitch(class_5819 random) {
        return 1.0f + (random.method_43057() - 0.5f) * 0.1f;
    }

    public static float getSoundVolume() {
        return 1.0f;
    }

    public void method_7860(class_2487 nbt) {
        super.method_7860(nbt);
        String[] keys = new String[]{"power", "speed", "duration", "cooldown", "gravity", "divergence", "pattern", "density", "timeOrbUsed", "icy"};
        Object[] values = new Object[]{Float.valueOf(this.power), Float.valueOf(this.speed), this.duration, this.cooldown, Float.valueOf(this.gravity), Float.valueOf(this.divergence), this.pattern, this.density, this.timeOrbUsed, this.icy};
        for (int i = 0; i < keys.length; ++i) {
            if (nbt.method_10545(keys[i])) continue;
            if (values[i] instanceof Integer) {
                nbt.method_10569(keys[i], ((Integer)values[i]).intValue());
                continue;
            }
            if (values[i] instanceof Float) {
                nbt.method_10548(keys[i], ((Float)values[i]).floatValue());
                continue;
            }
            if (values[i] instanceof String) {
                nbt.method_10582(keys[i], (String)values[i]);
                continue;
            }
            if (!(values[i] instanceof Boolean)) continue;
            nbt.method_10556(keys[i], ((Boolean)values[i]).booleanValue());
        }
        this.hideDyeSection(nbt);
    }

    private void hideDyeSection(class_2487 nbt) {
        nbt.method_10569("HideFlags", nbt.method_10550("HideFlags") | class_1799.class_5422.field_25774.method_30269());
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (stack.method_7985()) {
            if (class_437.method_25442()) {
                this.nbtTooltip(stack, tooltip);
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.arcadiandream.shot.tooltip"));
            }
        }
        super.method_7851(stack, world, tooltip, context);
    }

    private void nbtTooltip(class_1799 stack, List<class_2561> tooltip) {
        class_2487 nbt = stack.method_7969();
        if (nbt != null) {
            class_2487 nbtDisplay = nbt.method_10562("display");
            float power = nbt.method_10583("power");
            float speed = nbt.method_10583("speed");
            int duration = nbt.method_10550("duration");
            int cooldown = nbt.method_10550("cooldown");
            float gravity = nbt.method_10583("gravity");
            float divergence = nbt.method_10583("divergence");
            String pattern = nbt.method_10558("pattern");
            int density = nbt.method_10550("density");
            String keyPrefix = "item.arcadiandream.shot.tooltip_";
            String formattedPower = BaseShotItem.formatFloatValue(power * ArcadianDream.CONFIG.danmakuDamageMultiplier());
            String formattedSpeed = BaseShotItem.formatFloatValue(speed);
            String formattedCooldown = BaseShotItem.formatFloatValue((float)cooldown / 20.0f * (float)ArcadianDream.CONFIG.danmakuCooldownMultiplier() / (float)(this.isTimeOrbUsed(stack) ? 2 : 1));
            String formattedGravity = BaseShotItem.formatFloatValue(gravity);
            String formattedDivergence = BaseShotItem.formatFloatValue(divergence);
            String formattedColor = ColorMap.matchesMap(this.getColor(stack)) ? this.getColorName(stack).getString() : String.format(Locale.ROOT, "#%06X", nbtDisplay.method_10550("color"));
            tooltip.add((class_2561)class_2561.method_43469((String)(keyPrefix + "power"), (Object[])new Object[]{formattedPower}));
            tooltip.add((class_2561)class_2561.method_43469((String)(keyPrefix + "speed"), (Object[])new Object[]{formattedSpeed}));
            tooltip.add((class_2561)class_2561.method_43469((String)(keyPrefix + "duration"), (Object[])new Object[]{Float.valueOf((float)duration / 20.0f)}));
            tooltip.add((class_2561)class_2561.method_43469((String)(keyPrefix + "cooldown"), (Object[])new Object[]{formattedCooldown}).method_10862(class_2583.field_24360.method_10977((class_124)(this.isTimeOrbUsed(stack) ? class_124.field_1064 : null))));
            tooltip.add((class_2561)class_2561.method_43469((String)(keyPrefix + "gravity"), (Object[])new Object[]{formattedGravity}));
            tooltip.add((class_2561)class_2561.method_43469((String)(keyPrefix + "divergence"), (Object[])new Object[]{formattedDivergence}));
            tooltip.add((class_2561)class_2561.method_43469((String)(keyPrefix + "pattern"), (Object[])new Object[]{class_2561.method_43471((String)("item.arcadiandream.bullet.pattern_" + pattern.toLowerCase()))}));
            tooltip.add((class_2561)class_2561.method_43469((String)(keyPrefix + "density"), (Object[])new Object[]{density}));
            tooltip.add((class_2561)class_2561.method_43469((String)(keyPrefix + "color"), (Object[])new Object[]{formattedColor}).method_10862(class_2583.field_24360.method_36139(this.getColor(stack))));
            if (this.isIcy(stack)) {
                tooltip.add((class_2561)class_2561.method_43471((String)(keyPrefix + "icy")));
            }
        }
    }

    private static String formatFloatValue(float value) {
        int intValue = (int)value;
        return (float)intValue == value ? Integer.toString(intValue) : String.format("%.2f", Float.valueOf(value));
    }

    private class_5250 getColorName(class_1799 stack) {
        int color = this.getColor(stack);
        return ColorMap.getTranslationKey(color);
    }

    @Override
    @NotNull
    public BaseBulletEntity getBullet(class_1937 world, class_1309 user) {
        return new BaseBulletEntity(world, user);
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    public boolean method_7846() {
        return false;
    }

    private void setParamFloat(class_1799 stack, String key, float value, float maxValue) {
        stack.method_7948().method_10548(key, Math.min(value, maxValue));
    }

    private void setParamInt(class_1799 stack, String key, int value, int maxValue) {
        stack.method_7948().method_10569(key, Math.min(value, maxValue));
    }

    private void setParamBoolean(class_1799 stack, String key, boolean value) {
        stack.method_7948().method_10556(key, value);
    }

    public void setPower(class_1799 stack, float power) {
        this.setParamFloat(stack, "power", power, this.maxPower);
    }

    public void setSpeed(class_1799 stack, float speed) {
        this.setParamFloat(stack, "speed", speed, this.maxSpeed);
    }

    public void setDuration(class_1799 stack, int duration) {
        this.setParamInt(stack, "duration", duration, this.maxDuration);
    }

    public void setCooldown(class_1799 stack, int cooldown) {
        this.setParamInt(stack, "cooldown", cooldown, this.maxCooldown);
    }

    public void setGravity(class_1799 stack, float gravity) {
        this.setParamFloat(stack, "gravity", gravity, this.maxGravity);
    }

    public void setDivergence(class_1799 stack, float divergence) {
        this.setParamFloat(stack, "divergence", divergence, this.maxDivergence);
    }

    public void setPattern(class_1799 stack, String pattern) {
        stack.method_7948().method_10582("pattern", pattern);
    }

    public void setDensity(class_1799 stack, int density) {
        this.setParamInt(stack, "density", density, this.maxDensity);
    }

    public void setTimeOrbUsed(class_1799 stack, boolean isUsed) {
        this.setParamBoolean(stack, "time_orb_used", isUsed);
    }

    public void setIcy(class_1799 stack, boolean isIcy) {
        this.setParamBoolean(stack, "icy", isIcy);
    }

    private float getParamFloat(class_1799 stack, String key) {
        return stack.method_7948().method_10583(key);
    }

    private int getParamInt(class_1799 stack, String key) {
        return stack.method_7948().method_10550(key);
    }

    private boolean getParamBoolean(class_1799 stack, String key) {
        return stack.method_7948().method_10577(key);
    }

    public float getPower(class_1799 stack) {
        return this.getParamFloat(stack, "power");
    }

    public float getSpeed(class_1799 stack) {
        return this.getParamFloat(stack, "speed");
    }

    public int getDuration(class_1799 stack) {
        return this.getParamInt(stack, "duration");
    }

    public int getCooldown(class_1799 stack) {
        return this.getParamInt(stack, "cooldown");
    }

    public float getGravity(class_1799 stack) {
        return this.getParamFloat(stack, "gravity");
    }

    public float getDivergence(class_1799 stack) {
        return this.getParamFloat(stack, "divergence");
    }

    public int getDensity(class_1799 stack) {
        return this.getParamInt(stack, "density");
    }

    public float getMaxPower() {
        return this.maxPower;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public int getMaxDuration() {
        return this.maxDuration;
    }

    public float getMaxGravity() {
        return this.maxGravity;
    }

    public float getMaxDivergence() {
        return this.maxDivergence;
    }

    public int getMaxDensity() {
        return this.maxDensity;
    }

    public boolean isTimeOrbUsed(class_1799 stack) {
        return this.getParamBoolean(stack, "time_orb_used");
    }

    public boolean isIcy(class_1799 stack) {
        return this.getParamBoolean(stack, "icy");
    }
}

