/*
 * Decompiled with CFR 0.152.
 */
package net.reimaden.arcadiandream.entity.custom.mob;

import com.google.common.collect.ImmutableList;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1395;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.reimaden.arcadiandream.ArcadianDream;
import net.reimaden.arcadiandream.entity.ai.DanmakuGoal;
import net.reimaden.arcadiandream.entity.custom.danmaku.BaseBulletEntity;
import net.reimaden.arcadiandream.entity.custom.danmaku.CircleBulletEntity;
import net.reimaden.arcadiandream.entity.custom.danmaku.PelletBulletEntity;
import net.reimaden.arcadiandream.entity.custom.danmaku.StarBulletEntity;
import net.reimaden.arcadiandream.entity.custom.mob.BaseFairyEntity;
import net.reimaden.arcadiandream.item.ModItems;
import net.reimaden.arcadiandream.item.custom.danmaku.MobBulletPatterns;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SunflowerFairyEntity
extends BaseFairyEntity {
    private final AttackPatterns patterns;
    private byte attackType;

    public SunflowerFairyEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 10;
        this.patterns = new AttackPatterns();
    }

    public static class_5132.class_5133 setAttributes() {
        return BaseFairyEntity.setAttributes().method_26868(class_5134.field_23716, 20.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new DanmakuGoal(this, 2.0, super.getAttackCooldown(), 10.0f));
        this.field_6201.method_6277(2, (class_1352)new class_1395((class_1314)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1308.class, 6.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[]{BaseFairyEntity.class}));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true, this::isTarget));
    }

    private boolean isTarget(class_1309 entity) {
        class_1799 stack;
        Optional trinketComponent = TrinketsApi.getTrinketComponent((class_1309)entity);
        if (trinketComponent.isEmpty()) {
            return true;
        }
        List list = ((TrinketComponent)trinketComponent.get()).getEquipped(ModItems.FAIRY_CHARM);
        if (list.size() > 0 && (stack = (class_1799)((class_3545)list.get(0)).method_15441()) != null) {
            class_2487 nbt = stack.method_7948();
            return nbt.method_10550("mode") == 1;
        }
        return true;
    }

    @Override
    public int getAttackCooldown() {
        int cooldown = super.getAttackCooldown();
        switch (this.getAttackType()) {
            case 0: 
            case 7: {
                cooldown = 20;
                break;
            }
            case 1: {
                cooldown = 40;
                break;
            }
            case 2: {
                cooldown = 60;
                break;
            }
            case 3: {
                cooldown = 30;
                break;
            }
            case 4: {
                cooldown = 12;
                break;
            }
            case 5: {
                cooldown = 35;
                break;
            }
            case 6: {
                cooldown = 25;
            }
        }
        return cooldown + this.getCooldownOffset();
    }

    @Override
    public void method_7105(class_1309 target, float pullProgress) {
        super.method_7105(target, pullProgress);
        switch (this.getAttackType()) {
            case 0: {
                this.patterns.burstAttack((class_1309)this, target, this.method_37908());
                break;
            }
            case 1: {
                this.patterns.spreadAttack((class_1309)this, target, this.method_37908());
                break;
            }
            case 2: {
                this.patterns.carpetBombAttack((class_1309)this, this.method_37908());
                break;
            }
            case 3: {
                this.patterns.arcAttack((class_1309)this, target, this.method_37908());
                break;
            }
            case 4: {
                this.patterns.crossAttack((class_1309)this, target, this.method_37908());
                break;
            }
            case 5: {
                this.patterns.ringAttack((class_1309)this, target, this.method_37908());
                break;
            }
            case 6: {
                this.patterns.tripleAttack((class_1309)this, target, this.method_37908());
                break;
            }
            case 7: {
                this.patterns.carpetBombAttackQuick((class_1309)this, this.method_37908());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + this.getAttackType());
            }
        }
    }

    public void method_29510(class_3218 world, boolean angerPersistent) {
        super.method_29510(world, angerPersistent);
        this.angerNearbyFairies();
    }

    private void angerNearbyFairies() {
        class_1309 attacker = this.method_6065();
        if (attacker == null) {
            return;
        }
        double d = this.method_26825(class_5134.field_23717);
        class_238 box = class_238.method_29968((class_243)this.method_19538()).method_1009(d, 10.0, d);
        this.method_37908().method_8390(BaseFairyEntity.class, box, class_1301.field_6155).stream().filter(fairy -> fairy != this).filter(fairy -> fairy.method_5968() == null).filter(fairy -> !fairy.method_5722((class_1297)attacker)).forEach(fairy -> {
            fairy.method_29513(attacker.method_5667());
            fairy.method_29509();
        });
    }

    @Override
    public float method_6017() {
        return super.method_6017() * 0.9f;
    }

    @Override
    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return 1.3f;
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10567("AttackType", this.getAttackType());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setAttackType(nbt.method_10571("AttackType"));
    }

    @Override
    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        byte attackType = (byte)this.method_6051().method_43048(8);
        this.setAttackType(attackType);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public static boolean canSpawn(class_1299<? extends BaseFairyEntity> type, class_5425 world, class_3730 reason, class_2338 pos, class_5819 random) {
        return BaseFairyEntity.canSpawn(type, world, reason, pos, random) && ArcadianDream.CONFIG.fairyOptions.spawnSunflowerFairies();
    }

    public byte getAttackType() {
        return this.attackType;
    }

    private void setAttackType(byte attackType) {
        this.attackType = attackType;
    }

    @Override
    public ImmutableList<BaseBulletEntity> availableBullets(class_1937 world, class_1309 user) {
        return ImmutableList.of((Object)((Object)new CircleBulletEntity(world, user)), (Object)((Object)new StarBulletEntity(world, user)), (Object)((Object)new PelletBulletEntity(world, user)));
    }

    private class AttackPatterns
    implements MobBulletPatterns {
        private AttackPatterns() {
        }

        private void burstAttack(class_1309 fairy, class_1309 target, class_1937 world) {
            this.createSpread(world, fairy, target, SunflowerFairyEntity.this.getRandomNumberProvider() + 2, 0.5f, 5.0f, 5.0f, 50, SunflowerFairyEntity.this.getBulletColor());
        }

        private void spreadAttack(class_1309 fairy, class_1309 target, class_1937 world) {
            this.createSpread(world, fairy, target, SunflowerFairyEntity.this.getRandomNumberProvider() + 7, 0.2f, 180.0f, 4.0f, 20, SunflowerFairyEntity.this.getBulletColor());
        }

        private void carpetBombAttack(class_1309 fairy, class_1937 world) {
            this.createRain(world, fairy, 15, 1.2f, 8.0f, 5.0f, 100, SunflowerFairyEntity.this.getBulletColor(), 0.1f);
        }

        private void arcAttack(class_1309 fairy, class_1309 target, class_1937 world) {
            this.createArc(world, fairy, target, 5, 0.5f, 0.0f, 6.0f, 50, SunflowerFairyEntity.this.getBulletColor());
        }

        private void crossAttack(class_1309 fairy, class_1309 target, class_1937 world) {
            this.createRing(world, fairy, target, 4, 0.65f, 0.0f, 3.0f, 40, SunflowerFairyEntity.this.getBulletColor());
        }

        private void ringAttack(class_1309 fairy, class_1309 target, class_1937 world) {
            this.createRing(world, fairy, target, 15, 0.45f, 0.0f, 4.0f, 60, SunflowerFairyEntity.this.getBulletColor());
        }

        private void tripleAttack(class_1309 fairy, class_1309 target, class_1937 world) {
            this.createTriple(world, fairy, target, 6, 0.8f, 5.0f, 4.0f, 50, SunflowerFairyEntity.this.getBulletColor());
        }

        private void carpetBombAttackQuick(class_1309 fairy, class_1937 world) {
            this.createRain(world, fairy, 15, 1.2f, 8.0f, 5.0f, 100, SunflowerFairyEntity.this.getBulletColor(), 0.1f);
        }

        @Override
        @NotNull
        public BaseBulletEntity getBullet(class_1937 world, class_1309 user) {
            return (BaseBulletEntity)((Object)SunflowerFairyEntity.this.availableBullets(world, user).get((int)SunflowerFairyEntity.this.getBulletType()));
        }
    }
}

