/*
 * Decompiled with CFR 0.152.
 */
package net.reimaden.arcadiandream.entity.custom.danmaku;

import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3857;
import net.minecraft.class_3966;
import net.minecraft.class_5819;
import net.reimaden.arcadiandream.ArcadianDream;
import net.reimaden.arcadiandream.damage.ModDamageSources;
import net.reimaden.arcadiandream.entity.custom.mob.BaseFairyEntity;
import net.reimaden.arcadiandream.item.ModItems;
import net.reimaden.arcadiandream.particle.ModParticles;
import net.reimaden.arcadiandream.sound.ModSounds;
import net.reimaden.arcadiandream.statistic.ModStats;

public class BaseBulletEntity
extends class_3857 {
    protected BaseBulletEntity(class_1299<? extends class_3857> entityType, class_1937 world) {
        super(entityType, world);
    }

    public BaseBulletEntity(class_1937 world, class_1309 owner) {
        super(null, owner, world);
    }

    protected BaseBulletEntity(class_1299<? extends class_3857> entityType, class_1309 owner, class_1937 world) {
        super(entityType, owner, world);
    }

    protected BaseBulletEntity(class_1299<? extends class_3857> entityType, double x, double y, double z, class_1937 world) {
        super(entityType, x, y, z, world);
    }

    protected class_1792 method_16942() {
        return null;
    }

    public boolean method_5862() {
        return false;
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().method_8608()) {
            class_1297 class_12972;
            if (this.field_6012 >= this.getDuration()) {
                this.discardBullet();
            }
            if ((class_12972 = this.method_24921()) instanceof class_1309) {
                class_1309 livingEntity = (class_1309)class_12972;
                if (livingEntity.field_6213 >= 19) {
                    this.discardBullet();
                }
            }
        }
        BaseBulletEntity.frozenParticles(this, this.method_37908());
    }

    private static void frozenParticles(BaseBulletEntity entity, class_1937 world) {
        if (!entity.isIcy()) {
            return;
        }
        float offset = 2.0f;
        double xOffset = entity.method_18798().field_1352 * (double)offset;
        double yOffset = entity.method_18798().field_1351 * (double)offset;
        double zOffset = entity.method_18798().field_1350 * (double)offset;
        world.method_8406((class_2394)class_2398.field_28013, entity.method_23317() - xOffset, entity.method_23318() + (double)(entity.method_17682() / 2.0f) - yOffset, entity.method_23321() - zOffset, 0.0, 0.0, 0.0);
    }

    private void discardBullet() {
        this.method_31472();
        this.despawnParticle((class_3218)this.method_37908());
    }

    protected void method_7454(class_3966 entityHitResult) {
        if (this.method_37908().method_8608()) {
            return;
        }
        super.method_7454(entityHitResult);
        class_1297 entity = entityHitResult.method_17782();
        class_1297 owner = this.method_24921();
        if (entity instanceof BaseFairyEntity && owner instanceof BaseFairyEntity) {
            return;
        }
        this.applyDamage(entity, owner);
    }

    protected void applyDamage(class_1297 target, class_1297 owner) {
        target.method_5643(ModDamageSources.danmaku(this.method_37908(), (class_1297)this, owner), this.getPower() * ArcadianDream.CONFIG.danmakuDamageMultiplier());
        if (this.isIcy() && target.method_32316()) {
            this.applyFreeze(target);
        }
    }

    protected void applyFreeze(class_1297 target) {
        int frozenTicks = target.method_32312();
        target.method_32317((int)Math.min((float)(target.method_32315() * 4), (float)frozenTicks + 10.0f * this.getPower()));
    }

    protected void method_7488(class_239 hitResult) {
        class_1297 entity;
        class_239.class_240 type = hitResult.method_17783();
        if (type == class_239.class_240.field_1331 && (entity = ((class_3966)hitResult).method_17782()) == this.method_24921()) {
            return;
        }
        super.method_7488(hitResult);
        this.postHit(type);
    }

    protected void postHit(class_239.class_240 type) {
        if (!this.method_37908().method_8608()) {
            this.method_5768();
            this.bulletEffects((class_3218)this.method_37908());
        }
    }

    private void bulletEffects(class_3218 serverWorld) {
        this.despawnParticle(serverWorld);
        this.method_5783(ModSounds.ENTITY_DANMAKU_HIT, 0.8f, BaseBulletEntity.getSoundPitch(this.field_5974));
    }

    private void despawnParticle(class_3218 serverWorld) {
        serverWorld.method_14199((class_2394)ModParticles.BULLET_DESPAWN, this.method_19538().method_10216(), this.method_19538().method_10214() + (double)(this.method_17682() / 2.0f), this.method_19538().method_10215(), 1, 0.0, 0.0, 0.0, 0.0);
    }

    public void cancelParticle(class_3218 serverWorld) {
        serverWorld.method_14199((class_2394)ModParticles.BULLET_CANCEL, this.method_19538().method_10216(), this.method_19538().method_10214() + (double)(this.method_17682() / 2.0f), this.method_19538().method_10215(), 1, 0.0, 0.0, 0.0, 0.0);
    }

    protected float getPower() {
        if (this.method_7495().method_7985()) {
            return this.method_7495().method_7948().method_10583("power");
        }
        return 0.0f;
    }

    protected int getDuration() {
        if (this.method_7495().method_7985()) {
            return this.method_7495().method_7948().method_10550("duration");
        }
        return 200;
    }

    protected float method_7490() {
        if (this.method_7495().method_7985()) {
            return this.method_7495().method_7948().method_10583("gravity");
        }
        return 0.0f;
    }

    public boolean isIcy() {
        if (this.method_7495().method_7985()) {
            return this.method_7495().method_7948().method_10577("icy");
        }
        return false;
    }

    public static float getSoundPitch(class_5819 random) {
        return 1.0f + (random.method_43057() - 0.5f) * 0.1f;
    }

    public boolean method_5863() {
        return true;
    }

    public boolean method_49108() {
        return false;
    }

    public float method_5871() {
        return (float)this.method_5829().method_17939() * 1.1f;
    }

    public boolean method_5698(class_1297 attacker) {
        return !BaseBulletEntity.playerHasMagatama((class_1309)attacker) || this.method_24921() == attacker;
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1657 player;
        if (this.method_5679(source)) {
            return false;
        }
        this.method_5785();
        class_1297 entity = source.method_5529();
        if (entity == this.method_24921()) {
            return false;
        }
        if (!this.method_37908().method_8608() && entity instanceof class_1657 && BaseBulletEntity.playerHasMagatama((class_1309)(player = (class_1657)entity)) && player.method_7357().method_7905(ModItems.MAGATAMA_NECKLACE, 0.0f) == 0.0f) {
            this.method_5768();
            this.cancelParticle((class_3218)this.method_37908());
            player.method_7357().method_7906(ModItems.MAGATAMA_NECKLACE, 10);
            player.method_7339(ModStats.BULLETS_CANCELLED, 1);
            return true;
        }
        return false;
    }

    private static boolean playerHasMagatama(class_1309 entity) {
        Optional trinketComponent = TrinketsApi.getTrinketComponent((class_1309)entity);
        return trinketComponent.isPresent() && ((TrinketComponent)trinketComponent.get()).isEquipped(ModItems.MAGATAMA_NECKLACE);
    }
}

