/*
 * Decompiled with CFR 0.152.
 */
package net.reimaden.arcadiandream.item.custom.tools;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_3468;
import net.minecraft.class_3966;
import net.reimaden.arcadiandream.entity.custom.danmaku.BaseBulletEntity;
import net.reimaden.arcadiandream.item.custom.tools.ModHammerItem;
import net.reimaden.arcadiandream.sound.ModSounds;
import net.reimaden.arcadiandream.util.RaycastHelper;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.api.ScaleTypes;

public class MiracleMalletItem
extends ModHammerItem {
    private static final Set<ScaleType> scaleTypes = new HashSet<ScaleType>();
    private static final Set<ScaleType> bulletScaleTypes = new HashSet<ScaleType>();
    private static final int defaultScale = 1;
    private static final float scale = 0.25f;
    private static final int hitboxScale = 2;
    private static final int maxScale = 4;
    private static final float visibilityScale = 0.5f;

    public MiracleMalletItem(class_1832 material, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(material, attackDamage, attackSpeed, settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (!world.method_8608()) {
            Predicate<class_1297> filter = e -> e instanceof BaseBulletEntity;
            class_3966 result = RaycastHelper.raycast(user, 16.0, filter);
            if (result != null && result.method_17783() == class_239.class_240.field_1331) {
                class_1297 entity = result.method_17782();
                ScaleData scale = ScaleTypes.WIDTH.getScaleData(entity);
                float pitch = scale.getScale();
                bulletScaleTypes.forEach(scaleType -> {
                    ScaleData data = scaleType.getScaleData(entity);
                    if (data.getScale() < 4.0f) {
                        data.setScale(data.getScale() + 0.75f);
                    }
                });
                if (pitch < 4.0f) {
                    MiracleMalletItem.playSound(world, entity, 1.0f + pitch * 0.1f - 0.15f);
                    MiracleMalletItem.incrementStatAndDamageStack(user, hand, stack);
                    return class_1271.method_22427((Object)stack);
                }
                return class_1271.method_22430((Object)stack);
            }
            if (user.method_5715()) {
                ScaleData hitbox = ScaleTypes.HITBOX_WIDTH.getScaleData((class_1297)user);
                ScaleData visibility = ScaleTypes.VISIBILITY.getScaleData((class_1297)user);
                AtomicBoolean isScaled = new AtomicBoolean();
                scaleTypes.forEach(scaleType -> {
                    ScaleData data = scaleType.getScaleData((class_1297)user);
                    if (data.getScale() != 0.25f) {
                        data.setScale(0.25f);
                        hitbox.setScale(2.0f);
                        visibility.setScale(0.5f);
                        isScaled.set(true);
                    } else if (data.getScale() != 1.0f) {
                        data.setScale(1.0f);
                        hitbox.setScale(1.0f);
                        visibility.setScale(1.0f);
                        isScaled.set(false);
                    }
                });
                MiracleMalletItem.playSound(world, user, isScaled.get() ? 0.8f : 1.0f);
                MiracleMalletItem.incrementStatAndDamageStack(user, hand, stack);
                user.method_7357().method_7906((class_1792)this, 60);
                return class_1271.method_22427((Object)stack);
            }
        }
        return class_1271.method_22430((Object)stack);
    }

    private static void playSound(class_1937 world, class_1657 user, float isScaled) {
        world.method_8396(null, user.method_24515(), ModSounds.ITEM_MIRACLE_MALLET_USE, user.method_5634(), 0.5f, isScaled);
    }

    private static void playSound(class_1937 world, class_1297 bullet, float pitch) {
        world.method_8396(null, bullet.method_24515(), ModSounds.ITEM_MIRACLE_MALLET_USE, bullet.method_5634(), 0.5f, pitch);
    }

    private static void incrementStatAndDamageStack(class_1657 user, class_1268 hand, class_1799 stack) {
        user.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
        stack.method_7956(1, (class_1309)user, e -> e.method_20236(hand));
    }

    static {
        scaleTypes.add(ScaleTypes.WIDTH);
        scaleTypes.add(ScaleTypes.HEIGHT);
        scaleTypes.add(ScaleTypes.DROPS);
        bulletScaleTypes.add(ScaleTypes.WIDTH);
        bulletScaleTypes.add(ScaleTypes.HEIGHT);
    }
}

