/*
 * Decompiled with CFR 0.152.
 */
package net.reimaden.arcadiandream.entity.ai;

import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_3532;
import net.reimaden.arcadiandream.entity.custom.DanmakuMob;
import net.reimaden.arcadiandream.entity.custom.mob.BaseFairyEntity;
import org.jetbrains.annotations.Nullable;

public class DanmakuGoal
extends class_1352 {
    private final class_1308 mob;
    private final DanmakuMob owner;
    @Nullable
    private class_1309 target;
    private int updateCountdownTicks = -1;
    private final double mobSpeed;
    private int seenTargetTicks;
    private int minIntervalTicks;
    private int maxIntervalTicks;
    private final float maxShootRange;
    private final float squaredMaxShootRange;

    public DanmakuGoal(DanmakuMob mob, double mobSpeed, int intervalTicks, float maxShootRange) {
        this(mob, mobSpeed, intervalTicks, intervalTicks, maxShootRange);
    }

    public DanmakuGoal(DanmakuMob mob, double mobSpeed, int minIntervalTicks, int maxIntervalTicks, float maxShootRange) {
        if (!(mob instanceof class_1309)) {
            throw new IllegalArgumentException("DanmakuGoal requires Mob implements DanmakuMob");
        }
        this.owner = mob;
        this.mob = (class_1308)mob;
        this.mobSpeed = mobSpeed;
        this.minIntervalTicks = minIntervalTicks;
        this.maxIntervalTicks = maxIntervalTicks;
        this.maxShootRange = maxShootRange;
        this.squaredMaxShootRange = maxShootRange * maxShootRange;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        class_1309 livingEntity = this.mob.method_5968();
        if (livingEntity == null || !livingEntity.method_5805()) {
            return false;
        }
        this.target = livingEntity;
        return true;
    }

    public boolean method_6266() {
        return this.method_6264();
    }

    public void method_6270() {
        this.target = null;
        this.seenTargetTicks = 0;
        this.updateCountdownTicks = -1;
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        double d = this.mob.method_5649(this.target.method_23317(), this.target.method_23318(), this.target.method_23321());
        boolean bl = this.mob.method_5985().method_6369((class_1297)this.target);
        int n = this.seenTargetTicks = bl ? (this.seenTargetTicks = this.seenTargetTicks + 1) : 0;
        if (d > (double)this.squaredMaxShootRange || this.seenTargetTicks < 5) {
            this.mob.method_5942().method_6335((class_1297)this.target, this.mobSpeed);
        } else {
            this.mob.method_5942().method_6340();
        }
        this.mob.method_5988().method_6226((class_1297)this.target, 30.0f, 180.0f);
        if (--this.updateCountdownTicks == 0) {
            if (!bl) {
                return;
            }
            float f = (float)Math.sqrt(d) / this.maxShootRange;
            float g = class_3532.method_15363((float)f, (float)0.1f, (float)1.0f);
            this.owner.method_7105(this.target, g);
            class_1308 class_13082 = this.mob;
            if (class_13082 instanceof BaseFairyEntity) {
                BaseFairyEntity fairy = (BaseFairyEntity)class_13082;
                this.setMinIntervalTicks(fairy.getAttackCooldown());
                this.setMaxIntervalTicks(fairy.getAttackCooldown());
            }
            this.updateCountdownTicks = class_3532.method_15375((float)(f * (float)(this.maxIntervalTicks - this.minIntervalTicks) + (float)this.minIntervalTicks));
        } else if (this.updateCountdownTicks < 0) {
            this.updateCountdownTicks = class_3532.method_15357((double)class_3532.method_16436((double)(Math.sqrt(d) / (double)this.maxShootRange), (double)this.minIntervalTicks, (double)this.maxIntervalTicks));
        }
    }

    private void setMinIntervalTicks(int minIntervalTicks) {
        this.minIntervalTicks = minIntervalTicks;
    }

    private void setMaxIntervalTicks(int maxIntervalTicks) {
        this.maxIntervalTicks = maxIntervalTicks;
    }
}

