/*
 * Decompiled with CFR 0.152.
 */
package net.reimaden.arcadiandream.compat.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5455;
import net.reimaden.arcadiandream.block.ModBlocks;
import net.reimaden.arcadiandream.compat.RitualCraftingLocations;
import net.reimaden.arcadiandream.compat.TooltipHelper;
import net.reimaden.arcadiandream.compat.jei.JEIPlugin;
import net.reimaden.arcadiandream.recipe.RitualCraftingRecipe;
import org.jetbrains.annotations.NotNull;

public class JEIRitualCraftingCategory
implements IRecipeCategory<RitualCraftingRecipe> {
    private final IGuiHelper guiHelper;
    private final class_5455 registryManager;
    public static final class_2960 UID = new class_2960("arcadiandream", "ritual_crafting");
    public static final class_2960 TEXTURE = new class_2960("arcadiandream", "textures/gui/ritual_crafting.png");
    private static final class_2960 MOON_ICON = new class_2960("arcadiandream", "textures/gui/moon.png");
    private static final class_2960 DIMENSION_ICON = new class_2960("arcadiandream", "textures/gui/dimension.png");
    public static final class_2561 TITLE = class_2561.method_43471((String)"arcadiandream.category.ritual_crafting");
    private final IDrawable background;
    private final IDrawable icon;

    public JEIRitualCraftingCategory(IGuiHelper guiHelper) {
        this.registryManager = class_310.method_1551().field_1687.method_30349();
        this.guiHelper = guiHelper;
        this.background = guiHelper.drawableBuilder(TEXTURE, 0, 0, 184, 184).setTextureSize(184, 184).build();
        this.icon = guiHelper.createDrawableItemStack(new class_1799((class_1935)ModBlocks.RITUAL_SHRINE));
    }

    @NotNull
    public RecipeType<RitualCraftingRecipe> getRecipeType() {
        return JEIPlugin.RITUAL_CRAFTING_TYPE;
    }

    @NotNull
    public class_2561 getTitle() {
        return TITLE;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, RitualCraftingRecipe recipe, @NotNull IFocusGroup focuses) {
        for (int i = 0; i < recipe.method_8117().size(); ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, RitualCraftingLocations.ONBASHIRAS[i][0], RitualCraftingLocations.ONBASHIRAS[i][1]).addIngredients((class_1856)recipe.method_8117().get(i));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, RitualCraftingLocations.OUTPUT_SLOT[0], RitualCraftingLocations.OUTPUT_SLOT[1]).addItemStack(recipe.method_8110(this.registryManager));
    }

    public void draw(@NotNull RitualCraftingRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull class_332 context, double mouseX, double mouseY) {
        IDrawableStatic moon_icon = this.guiHelper.drawableBuilder(MOON_ICON, 0, 0, 16, 16).setTextureSize(16, 16).build();
        IDrawableStatic dimension_icon = this.guiHelper.drawableBuilder(DIMENSION_ICON, 0, 0, 16, 16).setTextureSize(16, 16).build();
        if (JEIRitualCraftingCategory.getMoonPhase(recipe)) {
            moon_icon.draw(context, RitualCraftingLocations.MOON_SLOT[0], RitualCraftingLocations.MOON_SLOT[1]);
        } else if (JEIRitualCraftingCategory.getDimension(recipe)) {
            dimension_icon.draw(context, RitualCraftingLocations.DIMENSION_SLOT[0], RitualCraftingLocations.DIMENSION_SLOT[1]);
        }
    }

    @NotNull
    public List<class_2561> getTooltipStrings(@NotNull RitualCraftingRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        if (JEIRitualCraftingCategory.getMoonPhase(recipe)) {
            if (mouseX >= (double)RitualCraftingLocations.MOON_SLOT[0] && mouseX <= (double)(RitualCraftingLocations.MOON_SLOT[0] + 16) && mouseY >= (double)RitualCraftingLocations.MOON_SLOT[1] && mouseY <= (double)(RitualCraftingLocations.MOON_SLOT[1] + 16)) {
                tooltip.add(TooltipHelper.moonPhase(recipe.getMoonPhase()));
            }
        } else if (JEIRitualCraftingCategory.getDimension(recipe) && mouseX >= (double)RitualCraftingLocations.DIMENSION_SLOT[0] && mouseX <= (double)(RitualCraftingLocations.DIMENSION_SLOT[0] + 16) && mouseY >= (double)RitualCraftingLocations.DIMENSION_SLOT[1] && mouseY <= (double)(RitualCraftingLocations.DIMENSION_SLOT[1] + 16)) {
            tooltip.add(TooltipHelper.dimension(recipe.getDimension()));
        }
        return tooltip;
    }

    private static boolean getDimension(RitualCraftingRecipe recipe) {
        return !recipe.getDimension().isEmpty();
    }

    private static boolean getMoonPhase(RitualCraftingRecipe recipe) {
        return recipe.getMoonPhase() != -1;
    }
}

