/*
 * Decompiled with CFR 0.152.
 */
package net.reimaden.arcadiandream.item.custom.danmaku;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.reimaden.arcadiandream.entity.custom.danmaku.BaseBulletEntity;
import net.reimaden.arcadiandream.item.custom.danmaku.BaseShotItem;
import net.reimaden.arcadiandream.util.ModTags;
import org.jetbrains.annotations.NotNull;

public interface MobBulletPatterns {
    default public void createRay(class_1937 world, class_1309 user, class_1309 target, int density, float speed, float divergence, float power, int duration, int color) {
        float pitch = user.method_36455();
        float yaw = user.method_5791();
        float targetHitbox = target.method_17682() / 2.0f * 5.0f;
        float n = speed / (float)density;
        class_1799 stack = this.getStack(world, user, power, duration, color);
        for (int i = 0; i < density; ++i) {
            BaseBulletEntity bulletEntity = this.getBullet(world, user);
            bulletEntity.method_16940(stack);
            bulletEntity.method_24919((class_1297)user, pitch + targetHitbox, yaw, 0.0f, speed, divergence);
            world.method_8649((class_1297)bulletEntity);
            speed -= n;
        }
    }

    default public void createSpread(class_1937 world, class_1309 user, class_1309 target, int density, float speed, float divergence, float power, int duration, int color) {
        float pitch = user.method_36455();
        float yaw = user.method_5791();
        float targetHitbox = target.method_17682() / 2.0f * 5.0f;
        class_1799 stack = this.getStack(world, user, power, duration, color);
        for (int i = 0; i < density; ++i) {
            BaseBulletEntity bulletEntity = this.getBullet(world, user);
            bulletEntity.method_16940(stack);
            bulletEntity.method_24919((class_1297)user, pitch + targetHitbox, yaw, 0.0f, speed, divergence + (float)density - 1.0f);
            world.method_8649((class_1297)bulletEntity);
        }
    }

    default public void createRing(class_1937 world, class_1309 user, class_1309 target, int density, float speed, float divergence, float power, int duration, int color) {
        float pitch = user.method_36455();
        float yaw = user.method_5791();
        float targetHitbox = target.method_17682() / 2.0f * 5.0f;
        class_1799 stack = this.getStack(world, user, power, duration, color);
        for (int i = 0; i < density; ++i) {
            BaseBulletEntity bulletEntity = this.getBullet(world, user);
            bulletEntity.method_16940(stack);
            float angle = (float)i * (360.0f / (float)density) + 180.0f;
            class_243 bullet = new class_243(0.0, 0.0, 1.0);
            bullet = bullet.method_1024(angle * ((float)Math.PI / 180));
            bullet = bullet.method_1037((pitch + targetHitbox) * ((float)Math.PI / 180));
            bullet = bullet.method_1024((-yaw + 180.0f) * ((float)Math.PI / 180));
            bulletEntity.method_7485(bullet.method_10216(), bullet.method_10214(), bullet.method_10215(), speed, divergence);
            world.method_8649((class_1297)bulletEntity);
        }
    }

    default public void createDouble(class_1937 world, class_1309 user, class_1309 target, int density, float speed, float divergence, float power, int duration, int color) {
        float pitch = user.method_36455();
        float yaw = user.method_5791();
        float spread = 22.5f;
        int rays = Math.min(density, 2);
        float targetHitbox = target.method_17682() / 2.0f * 5.0f;
        float n = speed / (float)density;
        class_1799 stack = this.getStack(world, user, power, duration, color);
        block0: for (int j = 0; j < rays; ++j) {
            float s = speed;
            int i = 0;
            while (true) {
                double d = i;
                double d2 = density <= 2 ? Math.ceil((float)density / 2.0f) : Math.floor((float)density / 2.0f);
                if (!(d < d2)) continue block0;
                BaseBulletEntity bulletEntity = this.getBullet(world, user);
                bulletEntity.method_16940(stack);
                float angle = 22.5f * (float)j - 11.25f;
                class_243 bullet = new class_243(0.0, 0.0, 1.0);
                bullet = bullet.method_1024((angle + 180.0f) * ((float)Math.PI / 180));
                bullet = bullet.method_1037((pitch + targetHitbox) * ((float)Math.PI / 180));
                bullet = bullet.method_1024((-yaw + 180.0f) * ((float)Math.PI / 180));
                bulletEntity.method_7485(bullet.method_10216(), bullet.method_10214(), bullet.method_10215(), s, divergence);
                world.method_8649((class_1297)bulletEntity);
                s -= n;
                ++i;
            }
        }
    }

    default public void createTriple(class_1937 world, class_1309 user, class_1309 target, int density, float speed, float divergence, float power, int duration, int color) {
        float pitch = user.method_36455();
        float yaw = user.method_5791();
        float spread = 15.0f;
        int rays = Math.min(density, 3);
        float targetHitbox = target.method_17682() / 2.0f * 5.0f;
        float n = speed / (float)density;
        class_1799 stack = this.getStack(world, user, power, duration, color);
        block0: for (int j = 0; j < rays; ++j) {
            float s = speed;
            int i = 0;
            while (true) {
                double d = i;
                double d2 = density <= 3 ? Math.ceil((float)density / 3.0f) : Math.floor((float)density / 3.0f);
                if (!(d < d2)) continue block0;
                BaseBulletEntity bulletEntity = this.getBullet(world, user);
                bulletEntity.method_16940(stack);
                float angle = 15.0f * (float)j - 15.0f;
                class_243 bullet = new class_243(0.0, 0.0, 1.0);
                bullet = bullet.method_1024((angle + 180.0f) * ((float)Math.PI / 180));
                bullet = bullet.method_1037((pitch + targetHitbox) * ((float)Math.PI / 180));
                bullet = bullet.method_1024((-yaw + 180.0f) * ((float)Math.PI / 180));
                bulletEntity.method_7485(bullet.method_10216(), bullet.method_10214(), bullet.method_10215(), s, divergence);
                world.method_8649((class_1297)bulletEntity);
                s -= n;
                ++i;
            }
        }
    }

    default public void createRain(class_1937 world, class_1309 user, int density, float speed, float divergence, float power, int duration, int color, float gravity) {
        float yaw = user.method_5791();
        class_1799 stack = this.getStack(world, user, power, duration, color);
        ((BaseShotItem)stack.method_7909()).setGravity(stack, gravity);
        for (int i = 0; i < density; ++i) {
            BaseBulletEntity bulletEntity = this.getBullet(world, user);
            bulletEntity.method_16940(stack);
            bulletEntity.method_24919((class_1297)user, -90.0f, yaw, 0.0f, speed, divergence + (float)density - 1.0f);
            world.method_8649((class_1297)bulletEntity);
        }
    }

    default public void createArc(class_1937 world, class_1309 user, class_1309 target, int density, float speed, float divergence, float power, int duration, int color) {
        float pitch = user.method_36455();
        float yaw = user.method_5791();
        float targetHitbox = target.method_17682() / 2.0f * 5.0f;
        float arc = 45.0f;
        class_1799 stack = this.getStack(world, user, power, duration, color);
        for (int i = 0; i < density; ++i) {
            BaseBulletEntity bulletEntity = this.getBullet(world, user);
            bulletEntity.method_16940(stack);
            float angle = (float)i * (45.0f / (float)(density - 1));
            class_243 bullet = new class_243(0.0, 0.0, 1.0);
            bullet = bullet.method_1024((angle + 157.5f) * ((float)Math.PI / 180));
            bullet = bullet.method_1037((pitch + targetHitbox) * ((float)Math.PI / 180));
            bullet = bullet.method_1024((-yaw + 180.0f) * ((float)Math.PI / 180));
            bulletEntity.method_7485(bullet.method_10216(), bullet.method_10214(), bullet.method_10215(), speed, divergence);
            world.method_8649((class_1297)bulletEntity);
        }
    }

    @NotNull
    private class_1799 getStack(class_1937 world, class_1309 user, float power, int duration, int color) {
        class_1799 stack = this.getBullet(world, user).method_7495();
        BaseShotItem item = (BaseShotItem)stack.method_7909();
        item.setPower(stack, power);
        item.setDuration(stack, duration);
        item.setColor(stack, color);
        if (user.method_5864().method_20210(ModTags.EntityTypes.FREEZING_DANMAKU_CAPABLE)) {
            item.setIcy(stack, true);
        }
        return stack;
    }

    @NotNull
    public BaseBulletEntity getBullet(class_1937 var1, class_1309 var2);
}

