/*
 * Decompiled with CFR 0.152.
 */
package net.reimaden.arcadiandream.entity.custom.mob;

import com.google.common.collect.ImmutableList;
import net.minecraft.class_1266;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1395;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5398;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.reimaden.arcadiandream.ArcadianDream;
import net.reimaden.arcadiandream.entity.ai.DanmakuGoal;
import net.reimaden.arcadiandream.entity.custom.danmaku.BaseBulletEntity;
import net.reimaden.arcadiandream.entity.custom.danmaku.CircleBulletEntity;
import net.reimaden.arcadiandream.entity.custom.danmaku.KunaiBulletEntity;
import net.reimaden.arcadiandream.entity.custom.danmaku.PelletBulletEntity;
import net.reimaden.arcadiandream.entity.custom.mob.BaseFairyEntity;
import net.reimaden.arcadiandream.item.custom.danmaku.MobBulletPatterns;
import net.reimaden.arcadiandream.util.ColorMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IceFairyEntity
extends BaseFairyEntity {
    private final AttackPatterns patterns = new AttackPatterns();
    private byte attackType;

    public IceFairyEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 setAttributes() {
        return BaseFairyEntity.setAttributes().method_26868(class_5134.field_23716, 16.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new DanmakuGoal(this, 2.0, super.getAttackCooldown(), 10.0f));
        this.field_6201.method_6277(2, (class_1352)new class_1395((class_1314)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1308.class, 6.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[]{BaseFairyEntity.class}));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true, arg_0 -> ((IceFairyEntity)this).method_29515(arg_0)));
        this.field_6185.method_6277(3, (class_1352)new class_5398((class_1308)this, false));
    }

    @Override
    public int getAttackCooldown() {
        int cooldown = super.getAttackCooldown();
        switch (this.getAttackType()) {
            case 0: {
                cooldown = 6;
                break;
            }
            case 1: 
            case 2: {
                cooldown = 20;
                break;
            }
            case 3: {
                cooldown = 10;
                break;
            }
            case 4: {
                cooldown = 12;
                break;
            }
            case 5: {
                cooldown = 40;
                break;
            }
            case 6: {
                cooldown = 25;
                break;
            }
            case 7: {
                cooldown = 30;
            }
        }
        return cooldown + this.getCooldownOffset();
    }

    @Override
    public void method_7105(class_1309 target, float pullProgress) {
        super.method_7105(target, pullProgress);
        switch (this.getAttackType()) {
            case 0: {
                this.patterns.rainAttack((class_1309)this, this.method_37908());
                break;
            }
            case 1: {
                this.patterns.hexagonAttack((class_1309)this, target, this.method_37908());
                break;
            }
            case 2: {
                this.patterns.divergedHexagonAttack((class_1309)this, target, this.method_37908());
                break;
            }
            case 3: {
                this.patterns.snowballAttack((class_1309)this, target, this.method_37908());
                break;
            }
            case 4: {
                this.patterns.rayAttack((class_1309)this, target, this.method_37908());
                break;
            }
            case 5: {
                this.patterns.rayButBigAttack((class_1309)this, target, this.method_37908());
                break;
            }
            case 6: {
                this.patterns.randomAttack((class_1309)this, target, this.method_37908());
                break;
            }
            case 7: {
                this.patterns.randomArcAttack((class_1309)this, target, this.method_37908());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + this.getAttackType());
            }
        }
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10567("AttackType", this.getAttackType());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setAttackType(nbt.method_10571("AttackType"));
    }

    @Override
    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        byte attackType = (byte)this.method_6051().method_43048(8);
        this.setAttackType(attackType);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    protected void initializeBullets(int bulletColor, int cooldownOffset, int randomNumberProvider, byte bulletType) {
        this.setBulletColor(ColorMap.getColorInt("cyan"));
        this.setCooldownOffset(cooldownOffset);
        this.setRandomNumberProvider(randomNumberProvider);
        this.setBulletType(bulletType);
    }

    public static boolean canSpawn(class_1299<? extends BaseFairyEntity> type, class_5425 world, class_3730 reason, class_2338 pos, class_5819 random) {
        return BaseFairyEntity.canSpawn(type, world, reason, pos, random) && ArcadianDream.CONFIG.fairyOptions.spawnIceFairies();
    }

    public byte getAttackType() {
        return this.attackType;
    }

    private void setAttackType(byte attackType) {
        this.attackType = attackType;
    }

    @Override
    public ImmutableList<BaseBulletEntity> availableBullets(class_1937 world, class_1309 user) {
        return ImmutableList.of((Object)((Object)new CircleBulletEntity(world, user)), (Object)((Object)new KunaiBulletEntity(world, user)), (Object)((Object)new PelletBulletEntity(world, user)));
    }

    private class AttackPatterns
    implements MobBulletPatterns {
        private AttackPatterns() {
        }

        private void rainAttack(class_1309 fairy, class_1937 world) {
            this.createRain(world, fairy, 1, 1.2f, 20.0f, 5.0f, 100, IceFairyEntity.this.getBulletColor(), 0.1f);
        }

        private void hexagonAttack(class_1309 fairy, class_1309 target, class_1937 world) {
            this.createRing(world, fairy, target, 6, 0.8f, 0.0f, 4.0f, 40, IceFairyEntity.this.getBulletColor());
        }

        private void divergedHexagonAttack(class_1309 fairy, class_1309 target, class_1937 world) {
            this.createRing(world, fairy, target, 6, 0.8f, IceFairyEntity.this.getRandomNumberProvider() + 10, 4.0f, 40, IceFairyEntity.this.getBulletColor());
        }

        private void snowballAttack(class_1309 fairy, class_1309 target, class_1937 world) {
            this.createSpread(world, fairy, target, 1, 0.8f, 5.0f, 3.0f, 50, IceFairyEntity.this.getBulletColor());
        }

        private void rayAttack(class_1309 fairy, class_1309 target, class_1937 world) {
            this.createRay(world, fairy, target, 15, 1.25f, 2.0f, 3.0f, 20, IceFairyEntity.this.getBulletColor());
        }

        private void rayButBigAttack(class_1309 fairy, class_1309 target, class_1937 world) {
            this.createDouble(world, fairy, target, 32, 1.25f, 3.0f, 3.0f, 30, IceFairyEntity.this.getBulletColor());
        }

        private void randomAttack(class_1309 fairy, class_1309 target, class_1937 world) {
            this.createTriple(world, fairy, target, IceFairyEntity.this.getRandomNumberProvider() + 2, 0.75f, IceFairyEntity.this.getRandomNumberProvider() + 4, 4.0f, 40, IceFairyEntity.this.getBulletColor());
        }

        private void randomArcAttack(class_1309 fairy, class_1309 target, class_1937 world) {
            this.createArc(world, fairy, target, IceFairyEntity.this.getRandomNumberProvider() + 1, 0.75f, IceFairyEntity.this.getRandomNumberProvider() + 6, 4.0f, 40, IceFairyEntity.this.getBulletColor());
        }

        @Override
        @NotNull
        public BaseBulletEntity getBullet(class_1937 world, class_1309 user) {
            return (BaseBulletEntity)((Object)IceFairyEntity.this.availableBullets(world, user).get((int)IceFairyEntity.this.getBulletType()));
        }
    }
}

