/*
 * Decompiled with CFR 0.152.
 */
package net.reimaden.arcadiandream.entity.custom.mob;

import com.google.common.collect.ImmutableList;
import net.minecraft.class_1266;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1395;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_156;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5398;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.reimaden.arcadiandream.ArcadianDream;
import net.reimaden.arcadiandream.entity.ai.DanmakuGoal;
import net.reimaden.arcadiandream.entity.custom.danmaku.BaseBulletEntity;
import net.reimaden.arcadiandream.entity.custom.danmaku.CircleBulletEntity;
import net.reimaden.arcadiandream.entity.custom.danmaku.PelletBulletEntity;
import net.reimaden.arcadiandream.entity.custom.mob.BaseFairyEntity;
import net.reimaden.arcadiandream.entity.variant.FairyPersonality;
import net.reimaden.arcadiandream.entity.variant.FairyVariant;
import net.reimaden.arcadiandream.item.custom.danmaku.MobBulletPatterns;
import org.jetbrains.annotations.NotNull;

public class FairyEntity
extends BaseFairyEntity {
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(FairyEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> PERSONALITY = class_2945.method_12791(FairyEntity.class, (class_2941)class_2943.field_13327);
    private final AttackPatterns patterns = new AttackPatterns();

    public FairyEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 setAttributes() {
        return BaseFairyEntity.setAttributes();
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new DanmakuGoal(this, 2.0, super.getAttackCooldown(), 10.0f));
        this.field_6201.method_6277(2, (class_1352)new class_1395((class_1314)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1308.class, 6.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[]{BaseFairyEntity.class}));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true, arg_0 -> ((FairyEntity)this).method_29515(arg_0)));
        this.field_6185.method_6277(3, (class_1352)new class_5398((class_1308)this, false));
    }

    @Override
    public int getAttackCooldown() {
        int cooldown = super.getAttackCooldown();
        switch (this.getPersonality()) {
            case AGGRESSIVE: {
                cooldown = 20;
                break;
            }
            case CURIOUS: 
            case SPONTANEOUS: 
            case TIMID: {
                cooldown = 40;
                break;
            }
            case CONFIDENT: {
                cooldown = 25;
                break;
            }
            case PLAYFUL: {
                cooldown = 30;
            }
        }
        return cooldown + this.getCooldownOffset();
    }

    @Override
    public void method_7105(class_1309 target, float pullProgress) {
        super.method_7105(target, pullProgress);
        switch (this.getPersonality()) {
            case AGGRESSIVE: {
                this.patterns.aggressive((class_1309)this, target, this.method_37908());
                break;
            }
            case CURIOUS: {
                this.patterns.curious((class_1309)this, target, this.method_37908());
                break;
            }
            case CONFIDENT: {
                this.patterns.confident((class_1309)this, target, this.method_37908());
                break;
            }
            case PLAYFUL: {
                this.patterns.playful((class_1309)this, target, this.method_37908());
                break;
            }
            case SPONTANEOUS: {
                this.patterns.spontaneous((class_1309)this, target, this.method_37908());
                break;
            }
            case TIMID: {
                this.patterns.timid((class_1309)this, target, this.method_37908());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.getPersonality()));
            }
        }
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", this.getTypeVariant());
        nbt.method_10569("Personality", this.getTypePersonality());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(VARIANT, (Object)nbt.method_10550("Variant"));
        this.field_6011.method_12778(PERSONALITY, (Object)nbt.method_10550("Personality"));
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)0);
        this.field_6011.method_12784(PERSONALITY, (Object)0);
    }

    @Override
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, class_1315 entityData, class_2487 entityNbt) {
        FairyVariant variant = (FairyVariant)((Object)class_156.method_27173((Object[])FairyVariant.values(), (class_5819)this.method_6051()));
        FairyPersonality personality = (FairyPersonality)((Object)class_156.method_27173((Object[])FairyPersonality.values(), (class_5819)this.method_6051()));
        this.setVariant(variant);
        this.setPersonality(personality);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public static boolean canSpawn(class_1299<? extends BaseFairyEntity> type, class_5425 world, class_3730 reason, class_2338 pos, class_5819 random) {
        return BaseFairyEntity.canSpawn(type, world, reason, pos, random) && ArcadianDream.CONFIG.fairyOptions.spawnFairies();
    }

    public FairyVariant getVariant() {
        return FairyVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.field_6011.method_12789(VARIANT);
    }

    private void setVariant(FairyVariant variant) {
        this.field_6011.method_12778(VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public FairyPersonality getPersonality() {
        return FairyPersonality.byId(this.getTypePersonality() & 0xFF);
    }

    private int getTypePersonality() {
        return (Integer)this.field_6011.method_12789(PERSONALITY);
    }

    private void setPersonality(FairyPersonality personality) {
        this.field_6011.method_12778(PERSONALITY, (Object)(personality.getId() & 0xFF));
    }

    @Override
    public ImmutableList<BaseBulletEntity> availableBullets(class_1937 world, class_1309 user) {
        return ImmutableList.of((Object)((Object)new CircleBulletEntity(world, user)), (Object)((Object)new PelletBulletEntity(world, user)));
    }

    private class AttackPatterns
    implements MobBulletPatterns {
        private AttackPatterns() {
        }

        private void aggressive(class_1309 fairy, class_1309 target, class_1937 world) {
            this.createRing(world, fairy, target, 10, 0.5f, 0.0f, 4.0f, 50, FairyEntity.this.getBulletColor());
        }

        private void curious(class_1309 fairy, class_1309 target, class_1937 world) {
            this.createRay(world, fairy, target, 5, 0.5f, 1.0f, 4.0f, 50, FairyEntity.this.getBulletColor());
        }

        private void confident(class_1309 fairy, class_1309 target, class_1937 world) {
            this.createSpread(world, fairy, target, 4, 0.5f, 5.0f, 4.0f, 50, FairyEntity.this.getBulletColor());
        }

        private void playful(class_1309 fairy, class_1309 target, class_1937 world) {
            this.createDouble(world, fairy, target, 6, 0.5f, 0.0f, 3.0f, 50, FairyEntity.this.getBulletColor());
        }

        private void spontaneous(class_1309 fairy, class_1309 target, class_1937 world) {
            this.createTriple(world, fairy, target, 3, 0.6f, 0.0f, 4.0f, 50, FairyEntity.this.getBulletColor());
        }

        private void timid(class_1309 fairy, class_1309 target, class_1937 world) {
            this.createSpread(world, fairy, target, 1, 0.4f, 1.0f, 3.0f, 50, FairyEntity.this.getBulletColor());
        }

        @Override
        @NotNull
        public BaseBulletEntity getBullet(class_1937 world, class_1309 user) {
            return (BaseBulletEntity)((Object)FairyEntity.this.availableBullets(world, user).get((int)FairyEntity.this.getBulletType()));
        }
    }
}

