/*
 * Decompiled with CFR 0.152.
 */
package net.reimaden.arcadiandream.entity.custom.mob;

import com.google.common.collect.ImmutableList;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1315;
import net.minecraft.class_1331;
import net.minecraft.class_1333;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3545;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4538;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import net.reimaden.arcadiandream.ArcadianDream;
import net.reimaden.arcadiandream.entity.ModEntities;
import net.reimaden.arcadiandream.entity.custom.DanmakuMob;
import net.reimaden.arcadiandream.entity.custom.danmaku.BaseBulletEntity;
import net.reimaden.arcadiandream.entity.custom.danmaku.CircleBulletEntity;
import net.reimaden.arcadiandream.item.ModItems;
import net.reimaden.arcadiandream.sound.ModSounds;
import net.reimaden.arcadiandream.util.ColorMap;
import net.reimaden.arcadiandream.util.ModTags;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BaseFairyEntity
extends class_1588
implements GeoEntity,
DanmakuMob,
class_5354 {
    @Nullable
    private UUID angryAt;
    private int angerTime;
    private static final class_6019 ANGER_TIME_RANGE = class_4802.method_24505((int)20, (int)39);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int bulletColor;
    private int cooldownOffset;
    private int randomNumberProvider;
    private static final class_2940<Byte> BULLET_TYPE = class_2945.method_12791(BaseFairyEntity.class, (class_2941)class_2943.field_13319);

    protected BaseFairyEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new class_1331((class_1308)this, 10, true);
        this.field_6206 = new class_1333((class_1308)this);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23720, 0.5);
    }

    public void method_7105(class_1309 target, float pullProgress) {
        if (this.getBulletType() > this.availableBullets(this.method_37908(), (class_1309)this).size() - 1 || this.getBulletType() < 0) {
            this.setBulletType((byte)0);
        }
        this.getDanmakuSound((class_1297)this, this.method_6051());
    }

    public int getAttackCooldown() {
        return 20;
    }

    public void method_6007() {
        super.method_6007();
        class_243 vec3d = this.method_18798();
        if (!this.method_24828() && vec3d.field_1351 < 0.0 && !(this.field_6207.method_6235() < this.method_23318())) {
            this.method_18799(vec3d.method_18805(1.0, 0.6, 1.0));
        }
    }

    protected void method_5958() {
        super.method_5958();
        this.method_29510((class_3218)this.method_37908(), true);
    }

    private PlayState predicate(AnimationState<?> state) {
        if (state.isMoving() && this.field_6235 == 0) {
            state.getController().setAnimation(RawAnimation.begin().then("move", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.method_24828()) {
            state.getController().setAnimation(RawAnimation.begin().then("idle.ground", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        state.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
    }

    protected float method_6107() {
        return 0.8f;
    }

    public float method_6017() {
        return super.method_6017() * 0.9f;
    }

    @Nullable
    protected class_3414 method_5994() {
        return ModSounds.ENTITY_FAIRY_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return ModSounds.ENTITY_FAIRY_HURT;
    }

    protected class_3414 method_6002() {
        return ModSounds.ENTITY_FAIRY_DEATH;
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return 1.1875f;
    }

    protected class_1408 method_5965(class_1937 world) {
        class_1407 birdNavigation = new class_1407((class_1308)this, world);
        birdNavigation.method_6332(false);
        birdNavigation.method_6354(true);
        birdNavigation.method_6331(true);
        return birdNavigation;
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        this.method_29517(nbt);
        nbt.method_10569("BulletColor", this.getBulletColor());
        nbt.method_10569("CooldownOffset", this.getCooldownOffset());
        nbt.method_10569("RandomNumberProvider", this.getRandomNumberProvider());
        nbt.method_10567("BulletType", this.getBulletType());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.method_29512(this.method_37908(), nbt);
        this.setBulletColor(nbt.method_10550("BulletColor"));
        this.setCooldownOffset(nbt.method_10550("CooldownOffset"));
        this.setRandomNumberProvider(nbt.method_10550("RandomNumberProvider"));
        this.field_6011.method_12778(BULLET_TYPE, (Object)nbt.method_10571("BulletType"));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(BULLET_TYPE, (Object)0);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        int bulletColor = ColorMap.getRandomBulletColor(this.method_6051());
        int cooldownOffset = this.method_6051().method_43048(11) - 5;
        int randomNumberProvider = this.method_6051().method_43048(11) + 1;
        byte bulletType = (byte)this.method_6051().method_43048(this.availableBullets(this.method_37908(), (class_1309)this).size());
        this.initializeBullets(bulletColor, cooldownOffset, randomNumberProvider, bulletType);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    protected void initializeBullets(int bulletColor, int cooldownOffset, int randomNumberProvider, byte bulletType) {
        this.setBulletColor(bulletColor);
        this.setCooldownOffset(cooldownOffset);
        this.setRandomNumberProvider(randomNumberProvider);
        this.setBulletType(bulletType);
    }

    public static boolean canSpawn(class_1299<? extends BaseFairyEntity> type, class_5425 world, class_3730 reason, class_2338 pos, class_5819 random) {
        return world.method_8407() != class_1267.field_5801 && BaseFairyEntity.isValidSpawn(world, pos) && BaseFairyEntity.method_20636(type, (class_1936)world, (class_3730)reason, (class_2338)pos, (class_5819)random) && !BaseFairyEntity.isSpawnBlockerNear(world, pos);
    }

    private static boolean isValidSpawn(class_5425 world, class_2338 pos) {
        return world.method_8320(pos.method_10074()).method_26164(ModTags.Blocks.FAIRIES_SPAWNABLE_ON) && BaseFairyEntity.isLightLevelValid(world, pos);
    }

    private static boolean isLightLevelValid(class_5425 world, class_2338 pos) {
        long timeOfDay = Objects.requireNonNull(world.method_8503()).method_30002().method_8532() % 24000L;
        return world.method_22339(pos) > 8 && timeOfDay >= 0L && timeOfDay < 12000L;
    }

    private static boolean isSpawnBlockerNear(class_5425 world, class_2338 pos) {
        class_1799 stack;
        if (!ArcadianDream.CONFIG.fairyCharmOptions.canPreventSpawning()) {
            return false;
        }
        class_1657 closestPlayer = world.method_18459((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), ArcadianDream.CONFIG.fairyCharmOptions.distance(), false);
        Optional trinketComponent = TrinketsApi.getTrinketComponent((class_1309)closestPlayer);
        if (trinketComponent.isEmpty()) {
            return false;
        }
        List list = ((TrinketComponent)trinketComponent.get()).getEquipped(ModItems.FAIRY_CHARM);
        if (list.size() > 0 && (stack = (class_1799)((class_3545)list.get(0)).method_15441()) != null) {
            class_2487 nbt = stack.method_7948();
            return closestPlayer != null && nbt.method_10550("mode") >= 1;
        }
        return false;
    }

    public float method_6144(class_2338 pos, class_4538 world) {
        return 0.0f;
    }

    public int method_29507() {
        return this.angerTime;
    }

    public void method_29514(int angerTime) {
        this.angerTime = angerTime;
    }

    @Nullable
    public UUID method_29508() {
        return this.angryAt;
    }

    public void method_29513(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    public void method_29509() {
        this.method_29514(ANGER_TIME_RANGE.method_35008(this.field_5974));
    }

    public int getBulletColor() {
        return this.bulletColor;
    }

    protected void setBulletColor(int bulletColor) {
        this.bulletColor = bulletColor;
    }

    public int getCooldownOffset() {
        return this.cooldownOffset;
    }

    protected void setCooldownOffset(int cooldownOffset) {
        this.cooldownOffset = cooldownOffset;
    }

    public int getRandomNumberProvider() {
        return this.randomNumberProvider;
    }

    protected void setRandomNumberProvider(int randomNumberProvider) {
        this.randomNumberProvider = randomNumberProvider;
    }

    public byte getBulletType() {
        return (Byte)this.field_6011.method_12789(BULLET_TYPE);
    }

    protected void setBulletType(byte bulletType) {
        this.field_6011.method_12778(BULLET_TYPE, (Object)bulletType);
    }

    @Override
    public ImmutableList<BaseBulletEntity> availableBullets(class_1937 world, class_1309 user) {
        return ImmutableList.of((Object)((Object)new CircleBulletEntity(world, user)));
    }

    public class_1310 method_6046() {
        return ModEntities.EntityGroups.YOUKAI;
    }
}

