/*
 * Decompiled with CFR 0.152.
 */
package net.reimaden.arcadiandream.datagen;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricAdvancementProvider;
import net.minecraft.class_156;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_185;
import net.minecraft.class_189;
import net.minecraft.class_1935;
import net.minecraft.class_2019;
import net.minecraft.class_2022;
import net.minecraft.class_2025;
import net.minecraft.class_2048;
import net.minecraft.class_2066;
import net.minecraft.class_2069;
import net.minecraft.class_2073;
import net.minecraft.class_2080;
import net.minecraft.class_2090;
import net.minecraft.class_2096;
import net.minecraft.class_2115;
import net.minecraft.class_2135;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_8129;
import net.reimaden.arcadiandream.advancement.BulletsCancelledCriterion;
import net.reimaden.arcadiandream.advancement.DanmakuModifiedCriterion;
import net.reimaden.arcadiandream.advancement.RitualCraftingCriterion;
import net.reimaden.arcadiandream.block.ModBlocks;
import net.reimaden.arcadiandream.item.ModItems;
import net.reimaden.arcadiandream.item.custom.danmaku.DyeableBullet;
import net.reimaden.arcadiandream.util.ColorMap;
import net.reimaden.arcadiandream.util.ModTags;
import net.reimaden.arcadiandream.world.structure.ModStructures;

public class ModAdvancementGenerator
extends FabricAdvancementProvider {
    private static final List<Consumer<Consumer<class_161>>> generators = (List)class_156.method_654((Object)Lists.newArrayList(), list -> list.add(new ModAdvancementsGenerator()));

    public ModAdvancementGenerator(FabricDataOutput output) {
        super(output);
    }

    public void generateAdvancement(Consumer<class_161> consumer) {
        generators.forEach(i -> i.accept(consumer));
    }

    private static class ModAdvancementsGenerator
    implements Consumer<Consumer<class_161>> {
        private static final class_2960 BACKGROUND = new class_2960("arcadiandream", "textures/block/danmaku_crafting_table_bottom.png");
        private static final class_1792[] PATTERN_ITEMS = new class_1792[]{ModItems.SPREAD_PATTERN, ModItems.RAY_PATTERN, ModItems.RING_PATTERN, ModItems.ARC_PATTERN, ModItems.DOUBLE_PATTERN, ModItems.TRIPLE_PATTERN};

        private ModAdvancementsGenerator() {
        }

        private static <T> class_185 makeDisplay(class_189 frame, T icon, String titleKey) {
            String prefix = "advancements.arcadiandream." + titleKey;
            class_1799 stack = icon instanceof class_1935 ? ((class_1935)icon).method_8389().method_7854() : (class_1799)icon;
            return new class_185(stack, (class_2561)class_2561.method_43471((String)(prefix + ".title")), (class_2561)class_2561.method_43471((String)(prefix + ".description")), null, frame, true, true, false);
        }

        private static String makeName(String name) {
            return new class_2960("arcadiandream", name).toString();
        }

        @Override
        public void accept(Consumer<class_161> consumer) {
            class_161 rootAdvancement = class_161.class_162.method_707().method_697((class_1935)ModItems.POWER_ITEM, (class_2561)class_2561.method_43471((String)"advancements.arcadiandream.root.title"), (class_2561)class_2561.method_43471((String)"advancements.arcadiandream.root.description"), BACKGROUND, class_189.field_1254, false, false, false).method_709("get_item", (class_184)class_2066.class_2068.method_8957((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8975(ModTags.Items.ITEMS).method_8976()})).method_694(consumer, ModAdvancementsGenerator.makeName("root"));
            class_161 mineDragonGem = class_161.class_162.method_707().method_701(rootAdvancement).method_693(ModAdvancementsGenerator.makeDisplay(class_189.field_1254, ModItems.DRAGON_GEM, "mine_dragon_gem")).method_709(ModItems.DRAGON_GEM.toString(), (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{ModItems.DRAGON_GEM})).method_694(consumer, ModAdvancementsGenerator.makeName("mine_dragon_gem"));
            class_161 ritualCrafting = class_161.class_162.method_707().method_701(mineDragonGem).method_693(ModAdvancementsGenerator.makeDisplay(class_189.field_1254, ModBlocks.RITUAL_SHRINE, "ritual_crafting")).method_709("ritual_crafting", (class_184)RitualCraftingCriterion.Conditions.create()).method_694(consumer, ModAdvancementsGenerator.makeName("ritual_crafting"));
            class_161 obtainHouraiElixir = class_161.class_162.method_707().method_701(ritualCrafting).method_693(ModAdvancementsGenerator.makeDisplay(class_189.field_1250, ModItems.HOURAI_ELIXIR, "obtain_hourai_elixir")).method_709(ModItems.HOURAI_ELIXIR.toString(), (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{ModItems.HOURAI_ELIXIR})).method_703(class_170.class_171.method_750((int)150)).method_694(consumer, ModAdvancementsGenerator.makeName("obtain_hourai_elixir"));
            class_161 shootDanmaku = class_161.class_162.method_707().method_701(rootAdvancement).method_693(ModAdvancementsGenerator.makeDisplay(class_189.field_1254, ModItems.CIRCLE_SHOT, "shoot_danmaku")).method_709("shot_danmaku", (class_184)class_2115.class_2117.method_9103((class_2019.class_2020)class_2019.class_2020.method_8844().method_8842(class_2022.class_2023.method_8855().method_48785(class_8129.method_48965(ModTags.DamageTypes.IS_DANMAKU)).method_8854(class_2048.class_2049.method_8916().method_8922(ModTags.EntityTypes.DANMAKU))))).method_694(consumer, ModAdvancementsGenerator.makeName("shoot_danmaku"));
            class_161 modifyDanmaku = class_161.class_162.method_707().method_701(shootDanmaku).method_693(ModAdvancementsGenerator.makeDisplay(class_189.field_1254, ModBlocks.DANMAKU_CRAFTING_TABLE, "modify_danmaku")).method_709("modified_danmaku", (class_184)DanmakuModifiedCriterion.Conditions.create()).method_694(consumer, ModAdvancementsGenerator.makeName("modify_danmaku"));
            class_161 curtainFire = class_161.class_162.method_707().method_701(modifyDanmaku).method_693(ModAdvancementsGenerator.makeDisplay(class_189.field_1249, ModAdvancementsGenerator.coloredBullet(ModItems.CIRCLE_SHOT, ColorMap.getColorInt("magenta")), "curtain_fire")).method_709("shot_danmaku", (class_184)class_2069.class_2071.method_35229((class_2073)class_2073.class_2074.method_8973().method_8975(ModTags.Items.SHOTS).method_20399(ModAdvancementsGenerator.densityNbt()).method_8976(), (class_2096.class_2100)class_2096.class_2100.field_9708)).method_694(consumer, ModAdvancementsGenerator.makeName("curtain_fire"));
            class_161 findAbandonedShrine = class_161.class_162.method_707().method_701(rootAdvancement).method_693(ModAdvancementsGenerator.makeDisplay(class_189.field_1254, ModItems.MYSTERIOUS_SEAL, "find_abandoned_shrine")).method_709(ModStructures.ABANDONED_SHRINE.method_29177().method_12832(), (class_184)class_2135.class_2137.method_43137((class_2090)class_2090.method_9017(ModStructures.ABANDONED_SHRINE))).method_694(consumer, ModAdvancementsGenerator.makeName("find_abandoned_shrine"));
            ModAdvancementsGenerator.requirePatternItemsCollected(class_161.class_162.method_707()).method_701(modifyDanmaku).method_693(ModAdvancementsGenerator.makeDisplay(class_189.field_1250, ModItems.RING_PATTERN, "pattern_master")).method_703(class_170.class_171.method_750((int)100)).method_694(consumer, ModAdvancementsGenerator.makeName("pattern_master"));
            class_161 sniperDuelFairy = class_161.class_162.method_707().method_701(shootDanmaku).method_693(ModAdvancementsGenerator.makeDisplay(class_189.field_1250, ModAdvancementsGenerator.coloredBullet(ModItems.STAR_SHOT, ColorMap.getColorInt("cyan")), "sniper_duel_fairy")).method_709("killed_fairy", (class_184)class_2080.class_2083.method_9001((class_2048.class_2049)class_2048.class_2049.method_8916().method_8922(ModTags.EntityTypes.FAIRIES).method_8924(class_2025.method_8860((class_2096.class_2099)class_2096.class_2099.method_9050((double)50.0))), (class_2022.class_2023)class_2022.class_2023.method_8855().method_48785(class_8129.method_48965(ModTags.DamageTypes.IS_DANMAKU)))).method_703(class_170.class_171.method_750((int)50)).method_694(consumer, ModAdvancementsGenerator.makeName("sniper_duel_fairy"));
            class_161 cancelBullets = class_161.class_162.method_707().method_701(rootAdvancement).method_693(ModAdvancementsGenerator.makeDisplay(class_189.field_1254, ModItems.STAR_ITEM, "cancel_bullets")).method_709("cancelled_bullets", (class_184)BulletsCancelledCriterion.Conditions.create(false)).method_694(consumer, ModAdvancementsGenerator.makeName("cancel_bullets"));
            class_161 cancelManyBullets = class_161.class_162.method_707().method_701(cancelBullets).method_693(ModAdvancementsGenerator.makeDisplay(class_189.field_1249, ModItems.BOMB_ITEM, "cancel_many_bullets")).method_709("cancelled_bullets", (class_184)BulletsCancelledCriterion.Conditions.amount(class_2096.class_2100.method_9053((int)50))).method_694(consumer, ModAdvancementsGenerator.makeName("cancel_many_bullets"));
            class_161 hisouSword = class_161.class_162.method_707().method_701(ritualCrafting).method_693(ModAdvancementsGenerator.makeDisplay(class_189.field_1254, ModItems.HISOU_SWORD, ModItems.HISOU_SWORD.toString())).method_709(ModItems.HISOU_SWORD.toString(), (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{ModItems.HISOU_SWORD})).method_694(consumer, ModAdvancementsGenerator.makeName(ModItems.HISOU_SWORD.toString()));
            class_161 obtainHeavenlyPeach = class_161.class_162.method_707().method_701(hisouSword).method_693(ModAdvancementsGenerator.makeDisplay(class_189.field_1249, ModItems.HEAVENLY_PEACH, "obtain_heavenly_peach")).method_709(ModItems.HEAVENLY_PEACH.toString(), (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{ModItems.HEAVENLY_PEACH})).method_694(consumer, ModAdvancementsGenerator.makeName("obtain_heavenly_peach"));
            class_161 mochiMalletKills = class_161.class_162.method_707().method_701(ritualCrafting).method_693(ModAdvancementsGenerator.makeDisplay(class_189.field_1254, ModAdvancementsGenerator.getMallet(), "mochi_mallet_kills")).method_709("kills_accumulated", (class_184)class_2066.class_2068.method_8957((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8977(new class_1935[]{ModItems.MOCHI_MALLET}).method_20399(ModAdvancementsGenerator.getKillsNbt()).method_8976()})).method_694(consumer, ModAdvancementsGenerator.makeName("mochi_mallet_kills"));
            class_161 obtainHihiirokaneIngot = class_161.class_162.method_707().method_701(ritualCrafting).method_693(ModAdvancementsGenerator.makeDisplay(class_189.field_1254, ModItems.HIHIIROKANE_INGOT, "obtain_hihiirokane_ingot")).method_709(ModItems.HIHIIROKANE_INGOT.toString(), (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{ModItems.HIHIIROKANE_INGOT})).method_694(consumer, ModAdvancementsGenerator.makeName("obtain_hihiirokane_ingot"));
            class_161 hihiirokaneArmor = class_161.class_162.method_707().method_701(obtainHihiirokaneIngot).method_693(ModAdvancementsGenerator.makeDisplay(class_189.field_1250, ModItems.HIHIIROKANE_CHESTPLATE, "hihiirokane_armor")).method_709("hihiirokane_armor", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{ModItems.HIHIIROKANE_HELMET, ModItems.HIHIIROKANE_CHESTPLATE, ModItems.HIHIIROKANE_LEGGINGS, ModItems.HIHIIROKANE_BOOTS})).method_703(class_170.class_171.method_750((int)200)).method_694(consumer, ModAdvancementsGenerator.makeName("hihiirokane_armor"));
            class_161 obtainHihiirokaneHoe = class_161.class_162.method_707().method_701(obtainHihiirokaneIngot).method_693(ModAdvancementsGenerator.makeDisplay(class_189.field_1250, ModItems.HIHIIROKANE_HOE, "obtain_hihiirokane_hoe")).method_709(ModItems.HIHIIROKANE_HOE.toString(), (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{ModItems.HIHIIROKANE_HOE})).method_703(class_170.class_171.method_750((int)150)).method_694(consumer, ModAdvancementsGenerator.makeName("obtain_hihiirokane_hoe"));
        }

        private static class_2487 densityNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10569("density", 25);
            return nbt;
        }

        private static class_1799 coloredBullet(class_1792 item, int color) {
            class_1799 stack = new class_1799((class_1935)item);
            ((DyeableBullet)stack.method_7909()).setColor(stack, color);
            return stack;
        }

        private static class_161.class_162 requirePatternItemsCollected(class_161.class_162 builder) {
            for (class_1792 item : PATTERN_ITEMS) {
                builder.method_709(class_7923.field_41178.method_10221((Object)item).method_12832(), (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{item}));
            }
            return builder;
        }

        private static class_1799 getMallet() {
            class_1799 stack = new class_1799((class_1935)ModItems.MOCHI_MALLET);
            stack.method_7980(ModAdvancementsGenerator.getKillsNbt());
            return stack;
        }

        private static class_2487 getKillsNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10569("kill_count", 100);
            return nbt;
        }
    }
}

