/*
 * Decompiled with CFR 0.152.
 */
package net.reimaden.arcadiandream.compat.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.reimaden.arcadiandream.compat.RitualCraftingLocations;
import net.reimaden.arcadiandream.compat.TooltipHelper;
import net.reimaden.arcadiandream.compat.emi.EMIPlugin;
import net.reimaden.arcadiandream.recipe.RitualCraftingRecipe;
import org.jetbrains.annotations.Nullable;

public class EMIRitualCraftingRecipe
implements EmiRecipe {
    private static final class_2960 TEXTURE = new class_2960("arcadiandream", "textures/gui/ritual_crafting.png");
    private static final class_2960 MOON_ICON = new class_2960("arcadiandream", "textures/gui/moon.png");
    private static final class_2960 DIMENSION_ICON = new class_2960("arcadiandream", "textures/gui/dimension.png");
    private final class_2960 id;
    private final List<EmiIngredient> inputs;
    private final EmiStack output;
    private final byte moonPhase;
    private final String dimension;

    public EMIRitualCraftingRecipe(RitualCraftingRecipe recipe) {
        class_5455 registryManager = Objects.requireNonNull(class_310.method_1551().field_1687).method_30349();
        this.id = recipe.method_8114();
        this.inputs = recipe.method_8117().stream().map(EmiIngredient::of).collect(Collectors.toList());
        this.output = EmiStack.of((class_1799)recipe.method_8110(registryManager));
        this.moonPhase = recipe.getMoonPhase();
        this.dimension = recipe.getDimension();
    }

    public EmiRecipeCategory getCategory() {
        return EMIPlugin.RITUAL_CRAFTING_CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.output);
    }

    public int getDisplayWidth() {
        return 184;
    }

    public int getDisplayHeight() {
        return 184;
    }

    public void addWidgets(WidgetHolder widget) {
        widget.addTexture(TEXTURE, 0, 0, 184, 184, 0, 0, 184, 184, 184, 184);
        for (int i = 0; i < this.inputs.size(); ++i) {
            widget.addSlot(this.inputs.get(i), RitualCraftingLocations.ONBASHIRAS[i][0] - 1, RitualCraftingLocations.ONBASHIRAS[i][1] - 1).drawBack(false);
        }
        widget.addSlot((EmiIngredient)this.output, RitualCraftingLocations.OUTPUT_SLOT[0] - 5, RitualCraftingLocations.OUTPUT_SLOT[1] - 5).recipeContext((EmiRecipe)this).large(true).drawBack(false);
        if (this.moonPhase != -1) {
            BiFunction<Integer, Integer, List> tooltipSupplier = (mouseX, mouseY) -> List.of(class_5684.method_32662((class_5481)TooltipHelper.moonPhase(this.moonPhase).method_30937()));
            widget.addTexture(MOON_ICON, RitualCraftingLocations.MOON_SLOT[0] + 1, RitualCraftingLocations.MOON_SLOT[1] - 1, 16, 16, 0, 0, 16, 16, 16, 16).tooltip(tooltipSupplier);
        } else if (!this.dimension.isEmpty()) {
            BiFunction<Integer, Integer, List> tooltipSupplier = (mouseX, mouseY) -> List.of(class_5684.method_32662((class_5481)TooltipHelper.dimension(this.dimension).method_30937()));
            widget.addTexture(DIMENSION_ICON, RitualCraftingLocations.DIMENSION_SLOT[0] + 1, RitualCraftingLocations.DIMENSION_SLOT[1] - 1, 16, 16, 0, 0, 16, 16, 16, 16).tooltip(tooltipSupplier);
        }
    }
}

