/*
 * Decompiled with CFR 0.152.
 */
package net.reimaden.arcadiandream.block.entity;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_7923;
import net.reimaden.arcadiandream.block.entity.ImplementedInventory;
import net.reimaden.arcadiandream.block.entity.ModBlockEntities;
import net.reimaden.arcadiandream.gui.DanmakuCraftingScreenHandler;
import net.reimaden.arcadiandream.item.ModItems;
import net.reimaden.arcadiandream.item.custom.danmaku.BaseShotItem;
import net.reimaden.arcadiandream.item.custom.danmaku.BulletCoreItem;
import net.reimaden.arcadiandream.networking.ModMessages;
import net.reimaden.arcadiandream.util.ColorMap;
import net.reimaden.arcadiandream.util.ModTags;
import org.jetbrains.annotations.Nullable;

public class DanmakuCraftingTableBlockEntity
extends class_2586
implements ImplementedInventory,
class_3908,
class_1278 {
    public static final int SIZE = 7;
    private final class_2371<class_1799> items = class_2371.method_10213((int)7, (Object)class_1799.field_8037);
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> DanmakuCraftingTableBlockEntity.this.modifierCount;
                case 1 -> DanmakuCraftingTableBlockEntity.this.repairCount;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    DanmakuCraftingTableBlockEntity.this.modifierCount = value;
                    break;
                }
                case 1: {
                    DanmakuCraftingTableBlockEntity.this.repairCount = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };
    private int modifierCount = 0;
    private int repairCount = 0;

    public DanmakuCraftingTableBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.DANMAKU_CRAFTING_TABLE, pos, state);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.items;
    }

    public void setInventory(class_2371<class_1799> list) {
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.set(i, (Object)((class_1799)list.get(i)));
        }
    }

    private void updateResult() {
        this.propertyDelegate.method_17391(0, 0);
        this.propertyDelegate.method_17391(1, 0);
        if (!this.isValid()) {
            this.items.set(2, (Object)class_1799.field_8037);
            return;
        }
        if (this.craftingShot()) {
            this.craftShot();
        } else if (this.modifyingShot()) {
            this.modifyShot();
        }
    }

    private void craftShot() {
        if (!(((class_1799)this.items.get(0)).method_7909() instanceof BulletCoreItem) || !((class_1799)this.items.get(3)).method_31574(ModItems.BIG_POWER_ITEM)) {
            this.items.set(2, (Object)class_1799.field_8037);
            return;
        }
        class_2960 itemId = class_7923.field_41178.method_10221((Object)((class_1799)this.items.get(0)).method_7909());
        String bulletCoreType = itemId.method_12832().split("_")[0];
        String shotType = bulletCoreType + "_shot";
        class_1799 shotStack = new class_1799((class_1935)class_7923.field_41178.method_10223(new class_2960("arcadiandream", shotType)));
        this.items.set(2, (Object)shotStack);
        shotStack.method_7948();
    }

    private void modifyShot() {
        if (!(((class_1799)this.items.get(1)).method_7909() instanceof BaseShotItem)) {
            this.items.set(2, (Object)class_1799.field_8037);
            return;
        }
        class_1799 modifiedShot = ((class_1799)this.items.get(1)).method_7972();
        this.modifyShot(modifiedShot);
        this.items.set(2, (Object)modifiedShot);
    }

    private void modifyShot(class_1799 stack) {
        class_1792 dye;
        BaseShotItem shot = (BaseShotItem)stack.method_7909();
        if (!((class_1799)this.items.get(3)).method_7960()) {
            class_1799 modifierStack = (class_1799)this.items.get(3);
            int count = modifierStack.method_7947();
            float percentage = 0.05f;
            float reductionPercentage = 0.02f;
            double maxPower = shot.getMaxPower();
            double maxSpeed = shot.getMaxSpeed();
            int maxDuration = shot.getMaxDuration();
            this.applyModifiers(stack, shot, modifierStack, count, percentage, reductionPercentage, maxPower, maxSpeed, maxDuration);
        }
        if (!((class_1799)this.items.get(4)).method_7960()) {
            int repairAmount = 50;
            for (int i = 0; i < ((class_1799)this.items.get(4)).method_7947() && stack.method_7919() > 0; ++i) {
                stack.method_7974(stack.method_7919() - repairAmount);
                this.propertyDelegate.method_17391(1, this.propertyDelegate.method_17390(1) + 1);
            }
        }
        if (!((class_1799)this.items.get(5)).method_7960()) {
            ImmutableList patternItems = ImmutableList.of((Object)ModItems.SPREAD_PATTERN, (Object)ModItems.RAY_PATTERN, (Object)ModItems.RING_PATTERN, (Object)ModItems.ARC_PATTERN, (Object)ModItems.DOUBLE_PATTERN, (Object)ModItems.TRIPLE_PATTERN);
            HashMap<class_1792, Integer> itemMap = new HashMap<class_1792, Integer>();
            for (int i = 0; i < patternItems.size(); ++i) {
                itemMap.put((class_1792)patternItems.get(i), i);
            }
            int itemId = itemMap.getOrDefault(((class_1799)this.items.get(5)).method_7909(), 0);
            switch (itemId) {
                case 0: {
                    shot.setPattern(stack, "spread");
                    break;
                }
                case 1: {
                    shot.setPattern(stack, "ray");
                    break;
                }
                case 2: {
                    shot.setPattern(stack, "ring");
                    break;
                }
                case 3: {
                    shot.setPattern(stack, "arc");
                    break;
                }
                case 4: {
                    shot.setPattern(stack, "double");
                    break;
                }
                case 5: {
                    shot.setPattern(stack, "triple");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No valid bullet pattern found!");
                }
            }
        }
        if (!((class_1799)this.items.get(6)).method_7960() && (dye = ((class_1799)this.items.get(6)).method_7909()) instanceof class_1769) {
            int colorInt = ColorMap.getColorInt(((class_1769)dye).method_7802().method_7792());
            shot.setColor(stack, colorInt);
        }
    }

    private void applyModifiers(class_1799 stack, BaseShotItem shot, class_1799 modifierStack, int count, float percentage, float reductionPercentage, double maxPower, double maxSpeed, int maxDuration) {
        if (modifierStack.method_31573(ModTags.Items.DANMAKU_POWER_MODIFIERS)) {
            maxPower *= 2.0;
            for (int i = 0; i < count && !(shot.getPower(stack) >= shot.getMaxPower()); ++i) {
                double power = shot.getPower(stack);
                double result = power * (1.0 + (double)percentage * (1.0 - power / maxPower));
                shot.setPower(stack, (float)result);
                shot.setCooldown(stack, shot.getCooldown(stack) + 1);
                double speed = shot.getSpeed(stack);
                double resultReductionSpeed = speed * (1.0 - (double)reductionPercentage * (speed / maxSpeed));
                int duration = shot.getDuration(stack);
                double resultReductionDuration = (double)duration * (1.0 - (double)reductionPercentage * ((double)duration / (double)maxDuration));
                shot.setSpeed(stack, Math.max((float)resultReductionSpeed, 0.05f));
                shot.setDuration(stack, Math.max((int)resultReductionDuration, 20));
                this.propertyDelegate.method_17391(0, this.propertyDelegate.method_17390(0) + 1);
            }
        } else if (modifierStack.method_31573(ModTags.Items.DANMAKU_DENSITY_MODIFIERS)) {
            for (int i = 0; i < count && shot.getDensity(stack) < shot.getMaxDensity(); ++i) {
                shot.setDensity(stack, shot.getDensity(stack) + 1);
                shot.setCooldown(stack, shot.getCooldown(stack) + 1);
                double resultReductionPower = (double)shot.getPower(stack) * (1.0 - (double)reductionPercentage * ((double)shot.getPower(stack) / maxPower));
                double speed = shot.getSpeed(stack);
                double resultReductionSpeed = speed * (1.0 - (double)reductionPercentage * (speed / maxSpeed));
                int duration = shot.getDuration(stack);
                double resultReductionDuration = (double)duration * (1.0 - (double)reductionPercentage * ((double)duration / (double)maxDuration));
                shot.setPower(stack, Math.max((float)resultReductionPower, 0.1f));
                shot.setSpeed(stack, Math.max((float)resultReductionSpeed, 0.05f));
                shot.setDuration(stack, Math.max((int)resultReductionDuration, 20));
                this.propertyDelegate.method_17391(0, this.propertyDelegate.method_17390(0) + 1);
            }
        } else if (modifierStack.method_31573(ModTags.Items.DANMAKU_SPEED_MODIFIERS)) {
            maxSpeed *= 2.0;
            for (int i = 0; i < count && !(shot.getSpeed(stack) >= shot.getMaxSpeed()); ++i) {
                double speed = shot.getSpeed(stack);
                double result = speed * (1.0 + (double)percentage * (1.0 - speed / maxSpeed));
                shot.setSpeed(stack, (float)result);
                shot.setCooldown(stack, shot.getCooldown(stack) + 1);
                double resultReductionPower = (double)shot.getPower(stack) * (1.0 - (double)reductionPercentage * ((double)shot.getPower(stack) / maxPower));
                int duration = shot.getDuration(stack);
                double resultReductionDuration = (double)duration * (1.0 - (double)reductionPercentage * ((double)duration / (double)maxDuration));
                shot.setPower(stack, Math.max((float)resultReductionPower, 0.1f));
                shot.setDuration(stack, Math.max((int)resultReductionDuration, 20));
                this.propertyDelegate.method_17391(0, this.propertyDelegate.method_17390(0) + 1);
            }
        } else if (modifierStack.method_31573(ModTags.Items.DANMAKU_DURATION_MODIFIERS)) {
            maxDuration *= 2;
            for (int i = 0; i < count && shot.getDuration(stack) < shot.getMaxDuration(); ++i) {
                double duration = shot.getDuration(stack);
                double result = duration * (1.0 + (double)percentage * (1.0 - duration / (double)maxDuration));
                result = Math.ceil(result);
                shot.setDuration(stack, (int)result);
                shot.setCooldown(stack, shot.getCooldown(stack) + 1);
                double resultReductionPower = (double)shot.getPower(stack) * (1.0 - (double)reductionPercentage * ((double)shot.getPower(stack) / maxPower));
                double speed = shot.getSpeed(stack);
                double resultReductionSpeed = speed * (1.0 - (double)reductionPercentage * (speed / maxSpeed));
                shot.setPower(stack, Math.max((float)resultReductionPower, 0.1f));
                shot.setSpeed(stack, Math.max((float)resultReductionSpeed, 0.05f));
                this.propertyDelegate.method_17391(0, this.propertyDelegate.method_17390(0) + 1);
            }
        } else if (modifierStack.method_7909() == ModItems.TIME_ORB) {
            if (!shot.isTimeOrbUsed(stack)) {
                shot.setTimeOrbUsed(stack, true);
                this.propertyDelegate.method_17391(0, this.propertyDelegate.method_17390(0) + 1);
            }
        } else if (modifierStack.method_7909() == ModItems.ENCHANTED_ICE && !shot.isIcy(stack)) {
            shot.setIcy(stack, true);
            shot.setDivergence(stack, Math.min(shot.getMaxDivergence(), shot.getDivergence(stack) + 5.0f));
            this.propertyDelegate.method_17391(0, this.propertyDelegate.method_17390(0) + 1);
        }
    }

    private boolean craftingShot() {
        return !((class_1799)this.items.get(0)).method_7960() && ((class_1799)this.items.get(1)).method_7960();
    }

    private boolean modifyingShot() {
        return ((class_1799)this.items.get(0)).method_7960() && !((class_1799)this.items.get(1)).method_7960();
    }

    private boolean isValid() {
        return this.craftingShot() || this.modifyingShot();
    }

    @Override
    public void method_5431() {
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            class_2540 data = PacketByteBufs.create();
            data.writeInt(this.items.size());
            for (class_1799 item : this.items) {
                data.method_10793(item);
            }
            data.method_10807(this.method_11016());
            for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)this.field_11863), (class_2338)this.method_11016())) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.ITEM_SYNC, (class_2540)data);
            }
        }
        this.updateResult();
        super.method_5431();
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.items);
        nbt.method_10569("modifierCount", this.modifierCount);
        nbt.method_10569("repairCount", this.repairCount);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.items);
        this.modifierCount = nbt.method_10550("modifierCount");
        this.repairCount = nbt.method_10550("repairCount");
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Override
    public boolean method_5443(class_1657 player) {
        if (this.field_11863 != null && this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return !(player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) > 64.0);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inventory, class_1657 player) {
        return new DanmakuCraftingScreenHandler(syncId, inventory, this, this.propertyDelegate);
    }

    public int[] method_5494(class_2350 side) {
        return new int[0];
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return false;
    }
}

