// CUSTOM MODIFIED OVERLAY by L00

// UI SETTINGS

uniform int iOvSet < ui_label = "OVERLAY IMAGE"; ui_type = "combo"; ui_items = "None\0AXON BODY 3\0AXON BODY 4\0MOTOROLA VB400\0MOTOROLA Si500\0MTF_THEMIS_05\0WOLFCOM\0LSNEWS\0LOS SUENOS SWAT\0PROVISION BODY CAM4\0";> = false;

// VARIABLES
#define bKeepAspectRatio 0
#include "ReShade.fxh"

static const float2 f2Center = float2(0.5f,0.5f);
static const float2 f2Resolution = float2(BUFFER_WIDTH, BUFFER_HEIGHT);
static const float2 f2PixelSize = 1.0 / f2Resolution;

// TEXTURES

texture tAxon3 			<source = "Ov_Axon3.png";> {Width = BUFFER_WIDTH;Height = BUFFER_HEIGHT;};
texture tAxon4 			<source = "Ov_Axon4.png";> {Width = BUFFER_WIDTH;Height = BUFFER_HEIGHT;};
texture tMoto400 		<source = "Ov_Motorola400.png";> {Width = BUFFER_WIDTH;Height = BUFFER_HEIGHT;};
texture tMoto500 		<source = "Ov_Motorola500.png";> {Width = BUFFER_WIDTH;Height = BUFFER_HEIGHT;};
texture tMTF_THEMIS_05		<source = "Ov_MTF_THEMIS_05.png";> {Width = BUFFER_WIDTH;Height = BUFFER_HEIGHT;};
texture tWolfcom 		<source = "Ov_Wolfcom.png";> {Width = BUFFER_WIDTH;Height = BUFFER_HEIGHT;};
texture tLSNEWS			<source = "Ov_LSNEWS.png";> {Width = BUFFER_WIDTH;Height = BUFFER_HEIGHT;};
texture tSuenos 		<source = "Ov_LosSuenos.png";> {Width = BUFFER_WIDTH;Height = BUFFER_HEIGHT;};
texture tProvision 		<source = "Ov_ProVision_BC4.png";> {Width = BUFFER_WIDTH;Height = BUFFER_HEIGHT;};


// SAMPLERS

sampler sAxon3 { Texture = tAxon3;MinFilter = LINEAR;MagFilter = LINEAR;AddressU = BORDER;AddressV = BORDER;};
sampler sAxon4 { Texture = tAxon4;MinFilter = LINEAR;MagFilter = LINEAR;AddressU = BORDER;AddressV = BORDER;};
sampler sMoto400 { Texture = tMoto400;MinFilter = LINEAR;MagFilter = LINEAR;AddressU = BORDER;AddressV = BORDER;};
sampler sMoto500 { Texture = tMoto500;MinFilter = LINEAR;MagFilter = LINEAR;AddressU = BORDER;AddressV = BORDER;};
sampler sMTF_THEMIS_05 { Texture = tMTF_THEMIS_05;MinFilter = LINEAR;MagFilter = LINEAR;AddressU = BORDER;AddressV = BORDER;};
sampler sWolfcom { Texture = tWolfcom;MinFilter = LINEAR;MagFilter = LINEAR;AddressU = BORDER;AddressV = BORDER;};
sampler sLSNEWS { Texture = tLSNEWS;MinFilter = LINEAR;MagFilter = LINEAR;AddressU = BORDER;AddressV = BORDER;};
sampler sSuenos { Texture = tSuenos;MinFilter = LINEAR;MagFilter = LINEAR;AddressU = BORDER;AddressV = BORDER;};
sampler sProvision { Texture = tProvision;MinFilter = LINEAR;MagFilter = LINEAR;AddressU = BORDER;AddressV = BORDER;};


// FUNCTIONS

float2 scale_uv(float2 uv, float2 scale, float2 center) {
	return (uv - center) * scale + center;
}

// PIXEL SHADERS

float4 PS_CustomOverlay(float4 pos : SV_POSITION,float2 uv : TEXCOORD) : SV_TARGET 
{
	float2 ar = f2Resolution.x > f2Resolution.y ? float2(f2Resolution.x / f2Resolution.y, 1.0) : float2(1.0, f2Resolution.y / f2Resolution.x);
	float2 corrected = bKeepAspectRatio ? ReShade::ScreenSize * ar : ReShade::ScreenSize;
	
	float2 stretch = corrected * ReShade::PixelSize;

	float2 uv_overlay;

	uv_overlay = scale_uv(uv,stretch,float2(f2Center.x, 1.0 - f2Center.y));

	float4 original = tex2D(ReShade::BackBuffer, uv);
	float4 overlay; 
	
	if(iOvSet == 1) overlay = tex2D(sAxon3, uv_overlay);
	if(iOvSet == 2) overlay = tex2D(sAxon4, uv_overlay);
	if(iOvSet == 3) overlay = tex2D(sMoto400, uv_overlay);
	if(iOvSet == 4) overlay = tex2D(sMoto500, uv_overlay);
	if(iOvSet == 5) overlay = tex2D(sMTF_THEMIS_05, uv_overlay);
	if(iOvSet == 6) overlay = tex2D(sWolfcom, uv_overlay);
	if(iOvSet == 7) overlay = tex2D(sLSNEWS, uv_overlay);
	if(iOvSet == 8) overlay = tex2D(sSuenos, uv_overlay);
	if(iOvSet == 9) overlay = tex2D(sProvision, uv_overlay);

	float opacity = overlay.a * 1.0f;

	return lerp(original, overlay, opacity);
}

technique CustomOverlay 
{
	pass 
	{
		VertexShader = PostProcessVS;
		PixelShader = PS_CustomOverlay;
	}
}
