#include "shared/cGraphics.fxh"

/*
    MIT License

    Copyright (C) 2015 Keijiro Takahashi

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in
    the Software without restriction, including without limitation the rights to
    use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
    the Software, and to permit persons to whom the Software is furnished to do so,
    subject to the following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
    FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
    COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
    IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
    CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

/*
    [Shader Options]
*/

uniform float _Falloff <
    ui_label = "Falloff";
    ui_type = "drag";
> = 0.5;

/*
    [Pixel Shaders]
*/

float4 PS_Vignette(VS2PS_Quad Input) : SV_TARGET0
{
    const float AspectRatio = float(BUFFER_WIDTH) / float(BUFFER_HEIGHT);
    Input.Tex0 = (Input.Tex0 * 2.0 - 1.0) * AspectRatio;
    float Radius = length(Input.Tex0) * _Falloff;
    float Radius_2_1 = (Radius * Radius) + 1.0;
    return 1.0 / (Radius_2_1 * Radius_2_1);
}

technique CShade_KinoVignette
{
    pass
    {
        // Multiplication blend mode
        BlendEnable = TRUE;
        BlendOp = ADD;
        SrcBlend = DESTCOLOR;
        DestBlend = ZERO;
        SRGBWriteEnable = WRITE_SRGB;

        VertexShader = VS_Quad;
        PixelShader = PS_Vignette;
    }
}
